
#import "TestShape.h"
#import "MyN3DCamera.h"

@implementation TestShape

- init
{
    [super init];
    tesselation = 8;
    macroHandle = NULL;
    return self;
}

- loadRIB:(char *)filepath
{
    static RtInt clipon = 1, clipoff = 0;
    
    if(filepath[0]==0) return self;
        
    myObject = RiResource("myresource",RI_ARCHIVE, RI_FILEPATH, &filepath, RI_NULL);
    macroHandle = RiMacroBegin("theMacro", RI_NULL);
    RiAttributeBegin();
    /* turn on 'clip object mode': qrman will look at only
     * what lies between WorldBegin and WorldEnd. If there is
     * no WorldBegin/WorldEnd pair, this will not work
     */
    RiOption(RI_ARCHIVE, "clipobject", &clipon, RI_NULL);
    RiReadArchive(myObject, NULL, RI_NULL);
    RiOption(RI_ARCHIVE, "clipobject", &clipoff, RI_NULL);
    RiAttributeEnd();
    RiMacroEnd();

    return self;
}

- renderSelf:(RtToken)context
{
    float f[3];
       
    f[0] = f[1] = tesselation;

    RiAttributeBegin();
	    
	RiGeometricApproximation(RI_TESSELATION, RI_PARAMETRIC, f, RI_NULL);
	
	f[0] = NXRedComponent(myColor);
	f[1] = NXGreenComponent(myColor);
	f[2] = NXBlueComponent(myColor);
	RiColor(f);
	
	if(macroHandle) RiMacroInstance(macroHandle,RI_NULL);
	
    RiAttributeEnd();
    
    return self;
}

- setTesselation:(int)value
{
    tesselation = value;
    return self;
}

- setShading:(int)value
{
    shading=value;
    return self;
}

- setColor:(NXColor)theColor
{
    myColor = theColor;
    return self;
}
@end
