/*
 Copyright (c) 2003 RIPE

 All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of the author not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
 AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

 $Id: sig.c,v 1.10 2003/04/15 12:02:04 can Exp $
*/

#include "sig.h"

void sigHandle(int signalType)
{
    static GStaticMutex sigMutex = G_STATIC_MUTEX_INIT;

    if (!g_static_mutex_trylock(&sigMutex))
        return;
    g_message("signal #%d received", signalType);
    if (signalType == SIGHUP) {
        g_message("reloading proxy_list");
        cleanHash();
        readAclList((gchar *) getConf("PROXYTABLE"));
        g_message("reloaded proxy_list");
    } else if (signalType == SIGUSR2) {
        connTrackDump(connTrack);
    } else if ((signalType == SIGABRT) || (signalType == SIGTERM)) {
        exit(0);
    }
    g_static_mutex_unlock(&sigMutex);
}

GThreadFunc sigThread(gpointer data)
{
    struct sigaction handler;

    memset(&handler, 0, sizeof(struct sigaction));
    handler.sa_handler = sigHandle;
    if (sigfillset(&handler.sa_mask) < 0) {
        local_error("sigfillset failed: %s", strerror(errno));
    }
    handler.sa_flags = 0;
    if (sigaction(SIGHUP, &handler, NULL) < 0) {
        local_error("sigaction failed: %s", strerror(errno));
    }
    if (sigaction(SIGUSR2, &handler, NULL) < 0) {
        local_error("sigaction failed: %s", strerror(errno));
    }
    handler.sa_flags = SA_RESETHAND;
    if (sigaction(SIGABRT, &handler, NULL) < 0) {
        local_error("sigaction failed: %s", strerror(errno));
    }
    if (sigaction(SIGTERM, &handler, NULL) < 0) {
        local_error("sigaction failed: %s", strerror(errno));
    }
    /* We ignore SIGPIPE for the sake of tcp sockets */
    handler.sa_handler = SIG_IGN;
    if (sigaction(SIGPIPE, &handler, NULL) < 0) {
        local_error("sigaction failed: %s", strerror(errno));
    }
    for (;;)
        pause();
}

void sigListen(void)
{
    g_thread_create((GThreadFunc) sigThread, NULL, FALSE, NULL);
    g_message("send HUP signal to reread proxy list");
    g_message("send USR2 signal to print current connections");
}
