/*
 Copyright (c) 2003 RIPE

 All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of the author not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
 AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

 $Id: acl.c,v 1.7 2003/01/21 13:03:46 can Exp $
*/

#include "acl.h"

void addToHash(MYSQL_ROW row, guint fldCount, gpointer user_data)
{
    gchar *node;

    node = g_ascii_strdown(row[0], (-1));
    g_hash_table_insert(aclHash, node, node);
    g_message("proxy_added %s", node);
}

GHRFunc hashRemove(gpointer key, gpointer value, gpointer user_data)
{
    g_message("proxy_removing %s", (gchar *) key);
    g_free(key);
    return ((GHRFunc) TRUE);
}

void readAclList(gchar * tablename)
{
    gchar *qry;

    qry = g_strdup_printf("select v6_addr from %s", tablename);
    db_foreach_query(qry, addToHash, NULL);
    g_free(qry);
}

GHRFunc aclLookup(GHashTable * hashTable, gconstpointer key)
{
    return (g_hash_table_lookup(hashTable, key));
}

void cleanHash(void)
{
    g_hash_table_foreach_remove(aclHash, (GHRFunc) & hashRemove, NULL);
}
