/***************************************
  $Revision: 1.6.2.4 $

  Reporting module.

  Status: REVIEWED, TESTED

 Author(s):       Tiago Antao

  ******************/ /******************
  Modification History:
        tiago (10/04/2003) Created.
  ******************/ /******************
  Copyright (c) 2003               RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#ifndef RT_DBUPDATE_H
#define RT_DBUPDATE_H

#include "rt.h"
#include "ep.h"
#include "cr.h"
#include "syntax_api.h"


typedef enum {
  RT_UPD_NONE,
  RT_UPD_DEBUG,
  RT_UPD_INFO,
  RT_UPD_NOTICE,
  RT_UPD_WARN,
  RT_UPD_ERROR,
  RT_UPD_CRIT,
  RT_UPD_FATAL
} RT_upd_level;

typedef enum {
  RT_UPD_ADD,
  RT_UPD_UPD,
  RT_UPD_DEL,
  RT_UPD_NOOP,
  RT_UPD_SYNTAX_ERR,
  RT_UPD_FWD
} RT_upd_op;

gchar* RT_EP_analyse(RT_context_t* ctx, EP_input_structure_t*);
void RT_unparsable_input(RT_context_t* ctx, gchar* object_candidate);

void RT_internal_error(RT_context_t* ctx);
void RT_help_request(RT_context_t* ctx);

void RT_invalid_keyword(RT_context_t* ctx, gchar* keyword);
void RT_invalid_keyword_combination(RT_context_t* ctx, gchar* keyword_comb);

void RT_set_object(RT_context_t* ctx, rpsl_object_t* object);
void RT_unset_object(RT_context_t* ctx, RT_upd_op operation, gboolean result);

void RT_syntax_error(RT_context_t* ctx);
void RT_syntax_ok(RT_context_t* ctx);

void RT_invalid_source(RT_context_t* ctx);

void RT_unknown_country(RT_context_t* ctx, gchar* country);

void RT_unknown_nic_suffix(RT_context_t* ctx);

void RT_enforcednew_exists(RT_context_t* ctx);
void RT_postproc_obj(RT_context_t* ctx, rpsl_object_t* postproc_obj_str);
void RT_no_objects_processed(RT_context_t* ctx);

void RT_kc_gen_diff(RT_context_t* ctx, GList* attributes);

/*
  Changed line stuff...
 */
void RT_changed_date_missing(RT_context_t* ctx, gchar* date, gchar* value);
void RT_multiple_changed_date_missing(RT_context_t* ctx);
void RT_peering_set_syntax(RT_context_t* ctx);
void RT_filter_set_syntax(RT_context_t* ctx);
void RT_changed_date_order(RT_context_t* ctx, gchar* value, gchar* previous);
void RT_changed_line_order(RT_context_t* ctx, gchar* msg, gchar* date);
void RT_changed_date_syntax(RT_context_t* ctx, gchar* msg);


/*
  has_auth - if some kind of credential was presented (and was wrong)
 */
void RT_auth_failure(RT_context_t* ctx,
		     gchar* type, GList* mntner,
		     gboolean has_auth);

void RT_auth_ok(RT_context_t* ctx,
		gchar* type, gchar* mntner,
		gboolean has_override);



/* delete...
 */
void RT_non_existent_object(RT_context_t* ctx);
void RT_object_exists(RT_context_t* ctx);

void RT_versions_dont_match(RT_context_t* ctx, rpsl_object_t* existing_object);
void RT_versions_match(RT_context_t* ctx);

void RT_object_still_referenced(RT_context_t* ctx);
void RT_object_not_referenced(RT_context_t* ctx);


/* maintainer of object has mail-from
   ok - succeded still
   only_mfrom - only has mfrom
*/
void RT_has_mail_from(RT_context_t* ctx, gboolean ok, gboolean only_mfrom);
void RT_no_mail_from(RT_context_t* ctx);


/* A refered object doesn't exist
 */
void RT_unknown_refered_object(RT_context_t* ctx, gchar* refered_name);
void RT_known_refered_object(RT_context_t* ctx, gchar* refered_name);


void RT_unknown_auto_nic_handle(RT_context_t* ctx, gchar* handle);
void RT_known_auto_nic_handle(RT_context_t* ctx, gchar* handle);

/*
 PKI
 */
void RT_report_key_info(RT_context_t* ctx, KM_key_return_t* info);
void RT_key_add_error(RT_context_t* ctx, KM_status_t status);
void RT_key_modify_error(RT_context_t* ctx, KM_status_t status);
void RT_key_remove_error(RT_context_t* ctx, KM_status_t status);
void RT_kc_gen_diff(RT_context_t* ctx, GList* warn_list) ;

/*
  To be researched
 */
void RT_RIP_update_error(RT_context_t* ctx, gchar* error);
void RT_RIP_update_ok(RT_context_t* ctx);

/*
  AS, IRT, mnt
 */
void RT_non_exist_mntner(RT_context_t* ctx, gchar* mntner);
void RT_parent_not_exist(RT_context_t* ctx);
void RT_origin_not_exist(RT_context_t* ctx);
void RT_manual_creation(RT_context_t* ctx);
void RT_automatic_creation(RT_context_t* ctx);

void RT_object_not_found(RT_context_t* ctx, gchar* name);

typedef struct {
  char *from;
  char *from_email;
  char *cc;
  char *subject;
  char *date;
  char *replyto;
  char *msgid;
} mail_hdr_t;
void RT_header(RT_context_t* ctx, gchar* to_address,
  gchar* from_address, gchar* subject);
void RT_from_mail(RT_context_t* ctx, mail_hdr_t* mail_info);
void RT_notif_origin(RT_context_t* ctx, gchar* origin);
void RT_notif_add_msg(RT_context_t* ctx, gchar* message);

void RT_status_check_failed(RT_context_t* ctx, gchar* reason);

void RT_credentials(RT_context_t *rt_ctx, GList *credentials);
void RT_full_input(RT_context_t *rt_ctx, char *filename);

void RT_no_frwd_create(RT_context_t *rt_ctx);

void RT_multiple_parents(RT_context_t *ctx, GList *parents);

/* auth check */
void RT_auth(RT_context_t* ctx, gchar* key, gchar* type, gchar* attr_checked,
        GList* auth_ok, GList* auth_fail, gchar *parent_type);

/* final result */
void RT_auth_result(RT_context_t* ctx, gboolean result, gboolean override);


#endif
