      PROGRAM parallel_laplace_solver
      implicit none
      include 'fpvm3.h'
      integer m, n, i, j, iters, maxiters
      integer NPROC, ME
      parameter (NPROC=3)
      parameter (m=6, n=m/NPROC)
      real*8 T(0:m+1,0:n+1), dTnorm2, eps, partial_dTnorm2
      parameter (eps = 1E-9, maxiters = 1.0/eps)
      real*8 Tbuf_curr_j(0:m+1), Tbuf_prev_j(0:m+1)
      integer msglabel, rc, taskid(0:NPROC-1)
      
      CALL setup_spmd(NPROC,taskid,ME)
      
      if (ME .eq. 0) 
     $   print 1002,ME,' Laplace: System-size mxn & NPROC=',
     $     m,n*NPROC,NPROC
      
      CALL initialize(T,m,n,ME)
      iters = 0
      if (ME .eq. 0)
     $   print 1001,ME,' Iteration','Error-norm2'
 100  continue
      iters = iters + 1
      dTnorm2 = 0
      CALL copybuf(Tbuf_prev_j, T, m, 0)
      do j=1,n
         CALL copybuf(Tbuf_curr_j, T, m, j)
         do i=1,m                   
            T(i,j) = 0.25*(Tbuf_curr_j(i-1) +
     $                     Tbuf_curr_j(i+1) +
     $                     Tbuf_prev_j(i)   + T(i,j+1) )
         enddo
         do i=1,m
            dTnorm2 = dTnorm2 + (T(i,j) - Tbuf_curr_j(i))**2
         enddo
         if (j .lt. n)
     $        CALL copybuf(Tbuf_prev_j, Tbuf_curr_j, m, 0)
      enddo
                                           
      msglabel = 1000
      if (ME .eq. 0) then
         do i=1,NPROC-1
            CALL PVMFrecv(-1,msglabel,rc)
            CALL PVMFunpack(REAL8,partial_dTnorm2,1,1,rc)
            dTnorm2 = dTnorm2 + partial_dTnorm2
         enddo
         CALL PVMFinitsend(PvmDataDefault,rc)
         CALL PVMFpack(REAL8,dTnorm2,1,1,rc)
         msglabel = 1500
         CALL PVMFmcast(NPROC-1,taskid(1),msglabel,rc)
      else
         CALL PVMFinitsend(PvmDataDefault,rc)
         CALL PVMFpack(REAL8,dTnorm2,1,1,rc)
         CALL PVMFsend(taskid(0),msglabel,rc)
         msglabel = 1500                   
         CALL PVMFrecv(taskid(0),msglabel,rc)
         CALL PVMFunpack(REAL8,dTnorm2,1,1,rc)
      endif
      
      if (dTnorm2 .lt. eps .or. iters .ge. maxiters) goto 99
      if (mod(iters,25) .eq. 0 .and. ME .eq. 0) 
     $     print 1000,ME,iters,dTnorm2
     
      CALL nn_exchange(T,m,n,ME,NPROC,taskid)
      goto 100                               
      
 99   continue
      if (ME .eq. 0) 
     $     print 1000,ME,iters,dTnorm2,eps
      CALL print_solution(iters,T,m,n,ME,NPROC)
 1000 format(1x,i4,':',i10,1p,G15.7,:,' < ',G15.7)
 1001 format(1x,i4,':',a10,a15)
 1002 format(1x,i4,':',a,3i6)

      CALL PVMFexit(rc)
      END
         
      SUBROUTINE setup_spmd(NPROC,taskid,ME)
      implicit none
      include 'fpvm3.h'
      integer PvmShowTids ! Omitted from PVM 3.3.6 fpvm3.h-file
      parameter (PvmShowTids = 14)
      integer ON, OFF
      parameter (ON = 1, OFF = 0)
      integer NPROC, taskid(0:NPROC-1), ME
      integer parent, mytid, rc, msglabel, i
      character*64 a_out

      msglabel = 0
      CALL PVMFmytid(mytid)
      CALL PVMFparent(parent)
      if (parent .lt. 0) then
         taskid(0) = mytid
         CALL getarg(0, a_out)
         CALL PVMFcatchout(ON,rc)
         CALL PVMFspawn(a_out,
     $        PVMTASKDEFAULT,'*',
     $        NPROC-1,taskid(1),
     $        rc)
         CALL PVMFinitsend(PvmDataDefault,rc)
         CALL PVMFpack(INTEGER4,taskid(0),NPROC,1,rc)
         CALL PVMFmcast(NPROC-1,taskid(1),msglabel,rc)
      else
         CALL PVMFrecv(parent,msglabel,rc)
         CALL PVMFunpack(INTEGER4,taskid(0),NPROC,1,rc)
      endif

      CALL PVMFsetopt(PvmShowTids,OFF,rc)
      
      do i=0,NPROC-1
         if (taskid(i) .eq. mytid) then
            ME = i
            return
         endif
      enddo
      ME = -1
      END

      SUBROUTINE initialize(T,m,n,ME)
      implicit none
      integer m, n, i, j, ME
      real*8 T(0:m+1,0:n+1), const
      const = 0
      if (ME .eq. 0) const = 100
      T(0,0) = const/2
      do i=1,m
         T(i,0) = const
      enddo
      T(m+1,0) = const/2
      do j=1,n+1
         do i=0,m+1
            T(i,j) = 0
         enddo
      enddo
      END
      
      SUBROUTINE copybuf(to, from, m, j)
      implicit none
      integer m, j, i
      real*8 to(0:m+1), from(0:m+1,0:j)
      do i=0,m+1
         to(i) = from(i,j)
      enddo
      END
      
      SUBROUTINE print_solution(iters,T,m,n,ME,NPROC)
      implicit none
      integer iters,m, n, i, j, ME, NPROC, jstart, jend
      real*8 T(0:m+1,0:n+1)
      if (ME .eq. 0) 
     $     print 1001,ME,' Solution T: (# of iters =',iters,')'
      jstart = 1
      if (ME .eq. 0) jstart = 0       ! Lower physical bdry
      jend = n
      if (ME .eq. NPROC-1) jend = n+1 ! Upper physical bdry
      do j=jend,jstart,-1             ! Ignore overlap areas
         print 1000,ME,(T(i,j),i=0,m+1) 
      enddo
 1000 format(1x,i4,':',11f7.2)      
 1001 format(1x,i4,':',a,i10,a)
      END 
      
      SUBROUTINE nn_exchange(T,m,n,ME,NPROC,taskid)
      implicit none
      include 'fpvm3.h'
      integer m, n, ME, NPROC, taskid(0:NPROC-1)
      real*8 T(0:m+1,0:n+1)
      integer rc, msglabel
      
      msglabel = 2000                                        
      if (ME .lt. NPROC-1) then
         CALL PVMFinitsend(PvmDataDefault,rc)
         CALL PVMFpack(REAL8,T(1,n),m,1,rc)
         CALL PVMFsend(taskid(ME+1),msglabel,rc)
      endif      
      if (ME .gt. 0) then
         CALL PVMFrecv(taskid(ME-1),msglabel,rc)
         CALL PVMFunpack(REAL8,T(1,0),m,1,rc)
         CALL PVMFinitsend(PvmDataDefault,rc)
         CALL PVMFpack(REAL8,T(1,1),m,1,rc)
         CALL PVMFsend(taskid(ME-1),msglabel,rc)
      endif
      if (ME .lt. NPROC-1) then
         CALL PVMFrecv(taskid(ME+1),msglabel,rc)
         CALL PVMFunpack(REAL8,T(1,n+1),m,1,rc)
      endif      
      END
