      PROGRAM parallel_laplace_solver
C==   Group & non-heterogeneous -version
      implicit none
      include 'fpvm3.h'
      external PvmSum
      integer m, n, i, j, iters, maxiters
      integer NPROC, ME
      parameter (NPROC=3)
      parameter (m=6, n=m/NPROC)
      real*8 T(0:m+1,0:n+1), dTnorm2, eps
      parameter (eps = 1E-9, maxiters = 1.0/eps)
      real*8 Tbuf_curr_j(0:m+1), Tbuf_prev_j(0:m+1)
      integer msglabel, rc, host_taskid
      character*32 group_name
      parameter (group_name = 'group_laplace')
      
      CALL setup_spmd_group(NPROC,host_taskid,ME,group_name)
      
      if (ME .eq. 0) 
     $   print 1002,ME,' Laplace(group): System-size mxn & NPROC=',
     $     m,n*NPROC,NPROC
      
      CALL initialize(T,m,n,ME)
      iters = 0
      if (ME .eq. 0)
     $   print 1001,ME,' Iteration','Error-norm2'
 100  continue
      iters = iters + 1
      dTnorm2 = 0
      CALL copybuf(Tbuf_prev_j, T, m, 0)
      do j=1,n
         CALL copybuf(Tbuf_curr_j, T, m, j)
         do i=1,m                   
            T(i,j) = 0.25*(Tbuf_curr_j(i-1) +
     $                     Tbuf_curr_j(i+1) +
     $                     Tbuf_prev_j(i)   + T(i,j+1) )
         enddo
         do i=1,m
            dTnorm2 = dTnorm2 + (T(i,j) - Tbuf_curr_j(i))**2
         enddo
         if (j .lt. n)
     $        CALL copybuf(Tbuf_prev_j, Tbuf_curr_j, m, 0)
      enddo
                                           
      msglabel = 1000
      CALL PVMFreduce(PvmSum,
     $     dTnorm2, 1, REAL8,
     $     msglabel,group_name,0,rc)

      msglabel = 1500
      if (ME .eq. 0) then
         CALL PVMFinitsend(PvmDataRaw,rc)
         CALL PVMFpack(REAL8,dTnorm2,1,1,rc)
         CALL PVMFbcast(group_name,msglabel,rc)
      else
         CALL PVMFrecv(host_taskid,msglabel,rc)
         CALL PVMFunpack(REAL8,dTnorm2,1,1,rc)
      endif
      
      if (dTnorm2 .lt. eps .or. iters .ge. maxiters) goto 99
      if (mod(iters,25) .eq. 0 .and. ME .eq. 0) 
     $     print 1000,ME,iters,dTnorm2
     
      CALL nn_exchange(T,m,n,ME,group_name)
      goto 100                               
      
 99   continue
      if (ME .eq. 0) 
     $     print 1000,ME,iters,dTnorm2,eps
      CALL print_solution(iters,T,m,n,ME,NPROC)
 1000 format(1x,i4,':',i10,1p,G15.7,:,' < ',G15.7)
 1001 format(1x,i4,':',a10,a15)
 1002 format(1x,i4,':',a,3i6)

      CALL PVMFlvgroup(group_name,rc)
      CALL PVMFexit(rc)
      END
         
      SUBROUTINE setup_spmd_group(NPROC,host_taskid,ME,group_name)
      implicit none
      include 'fpvm3.h'
      integer PvmShowTids ! Omitted from PVM 3.3.6 fpvm3.h-file
      parameter (PvmShowTids = 14)
      integer ON, OFF
      parameter (ON = 1, OFF = 0)
      integer MAXPROC
      parameter (MAXPROC = 100)
      integer NPROC, host_taskid, taskid(MAXPROC), ME
      integer mytid, rc, i
      character*64 a_out
      character*32 group_name

      CALL PVMFmytid(mytid)
      CALL PVMFparent(host_taskid)
      CALL PVMFjoingroup(group_name,ME)

      if (ME .eq. 0) then
         CALL getarg(0, a_out)
         CALL PVMFcatchout(ON,rc)
         CALL PVMFspawn(a_out,
     $        PVMTASKDEFAULT,'*',
     $        NPROC-1,taskid,
     $        rc)
      endif
      
      CALL PVMFsetopt(PvmShowTids,OFF,rc)

      CALL PVMFbarrier(group_name,NPROC,rc)
      END

      SUBROUTINE initialize(T,m,n,ME)
      implicit none
      integer m, n, i, j, ME
      real*8 T(0:m+1,0:n+1), const
      const = 0
      if (ME .eq. 0) const = 100
      T(0,0) = const/2
      do i=1,m
         T(i,0) = const
      enddo
      T(m+1,0) = const/2
      do j=1,n+1
         do i=0,m+1
            T(i,j) = 0
         enddo
      enddo
      END
      
      SUBROUTINE copybuf(to, from, m, j)
      implicit none
      integer m, j, i
      real*8 to(0:m+1), from(0:m+1,0:j)
      do i=0,m+1
         to(i) = from(i,j)
      enddo
      END
      
      SUBROUTINE print_solution(iters,T,m,n,ME,NPROC)
      implicit none
      integer iters,m, n, i, j, ME, NPROC, jstart, jend
      real*8 T(0:m+1,0:n+1)
      if (ME .eq. 0) 
     $     print 1001,ME,' Solution T: (# of iters =',iters,')'
      jstart = 1
      if (ME .eq. 0) jstart = 0       ! Lower physical bdry
      jend = n
      if (ME .eq. NPROC-1) jend = n+1 ! Upper physical bdry
      do j=jend,jstart,-1             ! Ignore overlap areas
         print 1000,ME,(T(i,j),i=0,m+1) 
      enddo
 1000 format(1x,i4,':',11f7.2)      
 1001 format(1x,i4,':',a,i10,a)
      END 

      SUBROUTINE nn_exchange(T,m,n,ME,group_name)
      implicit none
      include 'fpvm3.h'
      integer m, n, ME
      real*8 T(0:m+1,0:n+1)
      integer North, South, rc, msglabel
      integer atid, alabel, alen
      character*32 group_name
      
      CALL PVMFgettid(group_name,ME+1,North)
      CALL PVMFgettid(group_name,ME-1,South)
                                        
      msglabel = 2000                                        
      if (North .gt. 0) then
         CALL PVMFpsend(North,msglabel,
     $                  T(1,n),m,REAL8,rc)
      endif      
      if (South .gt. 0) then
         CALL PVMFprecv(South,msglabel,
     $                  T(1,0),m,REAL8,
     $                  atid,alabel,alen,rc)
         CALL PVMFpsend(South,msglabel,
     $                  T(1,1),m,REAL8,rc)
      endif
      if (North .gt. 0) then
         CALL PVMFprecv(North,msglabel,
     $                  T(1,n+1),m,REAL8,
     $                  atid,alabel,alen,rc)
      endif      
      END
