#include <stdio.h>
#include <stdlib.h>
#include "pvm3.h"

int *attach_slaves(int *NPROC, int *ME)
{
  int mytid = pvm_mytid();
  int parent = pvm_parent();
  int *taskid;
  int i, msglabel = 0;

  if (parent > 0) {
    /* Receive taskids from HOST-process */
    pvm_recv(parent,msglabel);
    pvm_upkint(NPROC,1,1);
    taskid = (int *)malloc((*NPROC + 1)*sizeof(*taskid));
    pvm_upkint(taskid,*NPROC,1);
    taskid[*NPROC] = parent; /* Save HOST's taskid */

    /* Find process index in taskid-table */
    for (i=0; i<*NPROC; i++) {
      if (taskid[i] == mytid) {
        *ME = i;
        return taskid;
      }
    }
  }

  *ME = -1;
  return NULL;
}

int main()
{
  int i, j;
  int Nlocal;
  int NPROC, ME;
  int *taskid, HOST;
  double *a, *b, partial_sum;

  taskid = attach_slaves(&NPROC, &ME);
  HOST = taskid[NPROC];

  /* Read input data from HOST */
  {
    int msglabel = 1000;
    pvm_recv(HOST,msglabel);
    pvm_upkint(&Nlocal,1,1);
    a = (double *)malloc(Nlocal*sizeof(*a));
    b = (double *)malloc(Nlocal*sizeof(*b));
    pvm_upkdouble(a,Nlocal,1);
    pvm_upkdouble(b,Nlocal,1);
  }
    
  /* Calculate partial results */
  partial_sum = 0;
  for (i=0; i<Nlocal; i++)
    partial_sum += a[i]*b[i];

  /* Send partial sum to HOST */
  {
    int msglabel = 2000;
    pvm_initsend(PvmDataDefault);
    pvm_pkdouble(&partial_sum,1,1);
    pvm_send(HOST,msglabel);
    free(a);
    free(b);
  }

  pvm_exit(); /* Finish with PVM */

  return 0;
}
