#define _NO_XPRINTF_

#include <stdio.h>
#ifdef SYSVSTR
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef  __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stddef.h>

#ifdef IMA_RS6K
#include <sys/select.h>
#endif

#include "easy.h"
#include "easydefs.h"

#ifndef MAXPRINTFMSG
#define MAXPRINTFMSG 65536 /* Enough for a single stderr/-out print ? */
#endif

static char buf[MAXPRINTFMSG];
static int buf_offset = 0;

static unsigned int node_zero_prints_only = 0;

static unsigned int sniff_readfp(fp)
     FILE *fp;
{
  static struct timeval timeout = { 0, 0 };
  fd_set rset;
  int rc = 0;
  int fd = fileno(fp);

  FD_ZERO(&rset);
  FD_SET(fd,&rset);

  rc = select(fd+1,&rset,NULL,NULL,&timeout);

  return (rc > 0) ? FD_ISSET(fd,&rset) : 0;
}

static void sniff_pvmdlogfile()
{
  static int skip_this = 0;
  static FILE *fp = NULL;
  static char prefix_string[20]="[tx00y0000] ";
  static int len_prefix_string = 0;
  int anywrites = 0;

  if (skip_this) return;

  if (!fp) {
    char file[100];
    int uid = getuid();
    sprintf(file,"/tmp/pvml.%d",uid);
    fp = fopen(file,"r");
    if (!fp) {
      char hostname[64];
      gethostname(hostname,sizeof(hostname));
      sprintf(file,"/tmp/pvml.%d.%s",uid,hostname);
      fp = fopen(file,"rb");
      if (!fp) {
	skip_this = 1;
	return; /* forget it */
      }
    } /* if (!fp) */
    sprintf(prefix_string,"[t%x] ",pvm_tidtohost(HOSTID) | 0x80000000);
    len_prefix_string = strlen(prefix_string);
  }
  
  while (sniff_readfp(fp)) {
    int nread = fread(buf,1,sizeof(buf),fp);
    if (nread > 0) {
      char *outbuf = buf;
      if (easy_cio) {
	if (strncmp(buf,prefix_string,len_prefix_string)==0) {
	  /* Filter out the prefix string */
	  outbuf += len_prefix_string;
	  nread -= len_prefix_string;
	}
      }
      if (nread > 0) {
	fwrite(outbuf,1,nread,stdout);
	anywrites++;
      }
    }
    else
      break;
  }

  if (anywrites) fflush(stdout);
}


void get_printfmsg()
{
  if (not_attached) return;
  if (ME == HOSTID) {
    int nbytes;
    char *c = buf;
    pvm_upkstr(c);
    nbytes = strlen(c);
    printf("%s%s", c, (c[nbytes-1] == '\n') ? "" : "\n");
    fflush(stdout);
  }
}


void check_printfmsg_arrival()
{
  if (not_attached) return;
  if (ME == HOSTID) {
    
    sniff_pvmdlogfile();

    while ( pvm_nrecv(ANYBODY,MSG_PRINTF) > 0 ) {
      get_printfmsg();
    }

  } /* if (ME == HOSTID) */
}

static void send_printfmsg()
{
  if (buf_offset > 0 && ME != HOSTID) {

    pvm_initsend(PvmDataDefault);
    pvm_pkstr(buf);
    pvm_send(HOSTID,MSG_PRINTF);

    /*
    printf("%d(t%x): send_printfmsg(offset=%d)\n",
	   ME,HOSTID,buf_offset);
	   */

    buf_offset = 0;
  }
}


static void xvfprintf(fp, fmt, args)
     FILE *fp;
     const char *fmt;
     va_list args;
{
  if (not_attached) {
    vfprintf(fp,fmt,args);
    return;
  }

  if (fmt && args) {
    if ( (ME != HOSTID) && (fp == stdout) ) {

      if ( (!node_zero_prints_only) || 
	   (node_zero_prints_only && (ME == 0)) ) {

	vsprintf(buf+buf_offset,fmt,args);
	buf_offset = strlen(buf);
	
	/* vfprintf(fp,fmt,args); */

	if (buf[buf_offset-1] == '\n' || 
	    buf_offset > MAXPRINTFMSG/4 )  send_printfmsg();
      }
      /* Otherwise: Discard the message (i.e. gsingle() has been called) */

    }
    else
      vfprintf(fp,fmt,args);
  }

  check_printfmsg_arrival();
}


void 
#ifdef __STDC__
xprintf(const char *fmt, ...)
#else
xprintf(va_alist)
     va_dcl
#endif
{
  va_list args;

#ifdef __STDC__
  va_start(args,fmt);
#else
  char    *fmt;
  va_start(args);
  fmt = va_arg(args, char *);
#endif

  xvfprintf(stdout,fmt,args);
  va_end(args);
}

void 
#ifdef __STDC__
xfprintf(FILE *fp, const char *fmt, ...)
#else
xfprintf(fp,va_alist)
     FILE *fp;
     va_dcl
#endif
{
  va_list args;

#ifdef __STDC__
  va_start(args,fmt);
#else
  char    *fmt;
  va_start(args);
  fmt = va_arg(args, char *);
#endif

  xvfprintf(fp,fmt,args);
  va_end(args);
}

void xfflush(fp)
     FILE *fp;
{
  check_printfmsg_arrival();
  send_printfmsg();
  fflush(fp);
}


void gsingle() /* Only NODE#0 prints */
{
  send_printfmsg();
  node_zero_prints_only = 1;
  gsync();
}


void gmulti() /* All nodes print */
{
  /* send_printfmsg(); */
  node_zero_prints_only = 0;
  gsync();
}
