#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

int (*pvmreceive)() = pvm_recv; /* Can be pvm_nrecv, too */
int bypassrecv = 0;             /* Future extension */

int unpackdata(routine, data, ndata)
     char *routine;
     void *data; 
     int ndata;
{
  int sizeof_data = 0; /* sizeof of data type in bytes */
  switch (DATATYPE) {
  case STRING:
    pvm_upkstr(data);
    sizeof_data = sizeof(char);
    break;
  case BYTE1:
    pvm_upkbyte(data,ndata,STRIDE);
    sizeof_data = sizeof(char);
    break;
  case INTEGER2:
    pvm_upkshort(data,ndata,STRIDE);
    sizeof_data = sizeof(short);
    break;
  case INTEGER4:
    pvm_upkint(data,ndata,STRIDE);
    sizeof_data = sizeof(int);
    break;
  case REAL4:
    pvm_upkfloat(data,ndata,STRIDE);
    sizeof_data = sizeof(float);
    break;
  case REAL8:
    pvm_upkdouble(data,ndata,STRIDE);
    sizeof_data = sizeof(double);
    break;
  case COMPLEX8:
    pvm_upkcplx(data,ndata,STRIDE);
    sizeof_data = 2*sizeof(float);
    break;
  case COMPLEX16:
    pvm_upkdcplx(data,ndata,STRIDE);
    sizeof_data = 2*sizeof(double);
    break;
  default:
    fprintf(stderr,"%s(@%d): Unknown datatype = %d\n",
	    routine,ME,DATATYPE);
    killproc(ME);
    break;
  }
  return sizeof_data;
}


int recv2d(source, msgtag, data, nrows, ncols, offset)
     int source; 
     int msgtag;
     void *data;
     int nrows;
     int ncols; 
     int offset;
{
  int bufid = 0;
  int sourcex = source;
#ifdef PICL
  int arrived = (bypassrecv) || (pvmreceive == pvm_nrecv);
#endif

  if (ME == HOSTID) check_printfmsg_arrival();

  if (source == HOSTID) { 
    source = HOSTID;
  }
  else if (source >= 0 && source < NUMNODES) {
    source = NODEID[source];
  }
  else if (source != ANYBODY) {
    fprintf(stderr,"recv2d(@%d): No such source %d (msgtag=%d)\n",
	    ME,source,msgtag);
    killproc(ME);
  }

#ifdef PICL
  if (logfp) {
    SETIDLETIME();
    if (!arrived) {
      arrived = pvm_probe(source,msgtag);
      if (!arrived) TRACEF(7,msgtag);
    }
  }
#endif /* PICL */

  if (!bypassrecv) {
    bufid = pvmreceive(source,msgtag);
    
    if (bufid < 0) {
      fprintf(stderr,"recv(@%d): Invalid bufid (source=%d, msgtag=%d)\n",
	      ME,sourcex,msgtag);
      perror("pvmreceive");
      killproc(ME);
    }
  }
  else {
    bufid = pvm_getrbuf();
  }

  if (bufid == 0 && pvmreceive == pvm_nrecv) return 0;

  if (ncols == 1) {
    unpackdata("recv",data,nrows);
  }
  else {
    int col;
    int oldstrd = setstride(1); /* Otherwise unexpected results */
    char *p = data;

    for (col=0; col<ncols; col++) {
      p += offset * unpackdata("recv2d",p,nrows);
    }
    
    setstride(oldstrd);
  }

#ifdef PICL
  if (logfp) {
    int nbytes = getdatasize() * nrows * ncols;
    recvinfo(bufid,
	     (sourcex == ANYBODY) ? &sourcex : NULL,
	     (msgtag == NOCARE) ? &msgtag : NULL,
	     NULL);
    TRACETIME();
    TRACEF(arrived ? 6 : 8,
	   sourcex == HOSTID ? PICLHOST : sourcex,msgtag,nbytes);
    UPDATEIDLETIME();
  }
#endif /* PICL */

  return bufid;
}


int recv(source, msgtag, data, ndata)
     int source;
     int msgtag;
     void *data;
     int ndata;
{
  return recv2d(source,msgtag,data,ndata,1,ndata);
}


int nrecv(source, msgtag, data, ndata)
     int source;
     int msgtag;
     void *data;
     int ndata;
{
  int bufid;
  int (*oldfunc)() = pvmreceive;

  pvmreceive = pvm_nrecv;

  bufid = recv(source,msgtag,data,ndata);

  pvmreceive = oldfunc;

  return bufid;
}


