/*
  
  pvmserver:
  A generic HOST-process to establish SPMD-like computing with EASYPVM
  
 */
#define _NO_XPRINTF_

#include <stdio.h>
#include <stdlib.h>

#ifdef SYSVSTR
#include <string.h>
#else
#include <strings.h>
#endif

#ifndef TEST
#include "easy.h"
#include "easydefs.h"
#else
extern int loadproc(char *args, int numcpus);
extern int createproc(char *ndffile);
extern double dclock();
extern int getcluster();
extern int waitall(int cl_id);
extern char *pvm_version();
#define NOCARE -1
#endif

#if defined(IMA_SGI) || defined(IMA_SGI5)
#include <getopt.h>
#else
extern int getopt __ProtoGlarp__ ((int argc, char **argv, char *optstring));
extern char *optarg;
extern int optind, opterr;
#endif

#define PVMSERVER "pvmserver"

#ifndef PVM_ARCH
#define PVM_ARCH "UNKNOWN PVM_ARCH"
#endif

static  int retcode = 0;

static void usage()
{
  fprintf(stderr,
	  "Usage: %s [-v] [-f ndffile] or [-n ncpus] node_prog [args]\n",
	  PVMSERVER);
  retcode++;
}

static void handle_args(argc, argv)
     int argc;
     char **argv;
{
  static char CMDOPT[] = "f:n:vd";
  char *ndffile = NULL;
  int ncpus = NOCARE;
  int debug = 0;
  int c;
  extern int waitall_verbose;
  extern int opterr, optint;
  
  waitall_verbose = 0;
  optind = 1;
  opterr = (argc > 1) ? 0 : 1;
  
  while ((c = getopt (argc,argv,CMDOPT)) != EOF) {
    extern char *optarg;
    switch (c) {
    case 'f':
      if (ncpus == NOCARE) {
	ndffile = (char *)malloc( (strlen(optarg) + 1) * sizeof(char));
	strcpy(ndffile,optarg);
      }
      else {
	fprintf(stderr,
		"%s: Option '-f ndffile' in conjuction with '-n ncpus'\n",
		PVMSERVER);
	opterr++;
      }
      break;
    case 'n':
      if (!ndffile && ncpus == NOCARE) {
	ncpus = atoi(optarg);
      }
      else {
	fprintf(stderr,
		"%s: Option '-n ncpus' in conjuction with '-f ndffile'\n",
		PVMSERVER);
	opterr++;
      }
      break;
    case 'v':
      waitall_verbose++;
      break;
    case 'd':
      debug++;
      break;
    default:
      fprintf(stderr,"%s: Invalid option\n",PVMSERVER);
      opterr++;
      break;
    } /* switch */
  } /* while */

  if (debug) {
    int i;
    char *EASY_NCPUS = getenv("EASY_NCPUS");

    printf("%s (debug): argc = %d, optind = %d, opterr = %d\n",
	   PVMSERVER,
	   argc,optind,opterr);
    for (i=0; i<argc; i++) {
      printf("\targv[%d] = '%s'\n",i,argv[i]);
    }
    if (ndffile) printf("\tndffile = '%s'\n",ndffile);
    if (ncpus != NOCARE) printf("\tncpus = %d\n",ncpus);
    if (EASY_NCPUS) printf("\tEASY_NCPUS = '%s'\n",EASY_NCPUS);
  }

  if (opterr) {
    ncpus = 0;
  }  
  else if (ndffile) {
    if (optind == argc) 
      ncpus = createproc(ndffile);
    else {
      fprintf(stderr,
	      "%s: No 'node_prog [args]' in conjuction with '-f ndffile'\n", 
	      PVMSERVER);
      ncpus = 0;
    }
  } 
  else {
    char *progargs = NULL;
    int i;

    for (i=optind; i<argc; i++) {
      if (i == optind) {
	progargs = 
	  (char *)malloc((strlen(argv[i]) + 2) * sizeof(char));
	progargs[0] = '\0';
      }
      else {
	progargs = 
	  (char *)realloc(progargs,
			  (strlen(progargs) + strlen(argv[i]) + 2) * 
			  sizeof(char));
      }
      strcat(progargs,argv[i]);
      if (i<argc-1) strcat(progargs," ");
    }
    
    ncpus = loadproc(progargs,ncpus);
    
    if (progargs) free(progargs);
  }
    
  if (ncpus > 0) {
    retcode = waitall(getcluster());
  }
  else
    usage();

}

main(argc, argv)
     int argc;
     char **argv;
{
  double start_time = dclock();

  printf("%s: PVM v%s, ARCH=%s\n",
	 PVMSERVER,pvm_version(),PVM_ARCH);
  fflush(stdout);

  handle_args(argc,argv);

  printf("%s: Elapsed time  %.2f seconds\n",
	 PVMSERVER,dclock()-start_time);
  fflush(stdout);
  
  exit(retcode);
}
