%***************************************************************************
%  FILE = frme.red 				Tue Nov  8 12:43:50 EST 1988
% 
%  Procedures in this file:
%  
%  FRMETRIC* NULLTETRAD* GAMMA* FRRIEMANN* FRRICCI* FRRICCISC** FRRICCISC*
%  FREINSTEIN* FRWEYL*
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

GLOBAL '(CURRENTCONNECTION INAMES);
GLOBAL '(FRMETRIC NULLTETRAD GAMMA FRRIEMANN FRRICCI FRRICCISC 
         FREINSTEIN FRWEYL);

FRMETRIC := 'ETA;
PUT ('FRMETRIC, 'SIMPFN, 'FRMETRIC!*);
GLOBAL '(INDICETEN);

% frmetric* constructs a null-tetrad metric.

SYMBOLIC PROCEDURE FRMETRIC!* (U);
BEGIN SCALAR TTRD, TTRDI, LEX;
  TTRD := NEWNME (MYCAR (U), FRMETRIC);
  IF MYCADR (U) THEN <<
    MKTNSR!* (TTRD, '(-2 -2), '(((0) 1 2)), 'NIL, 'METRIC);
    LEX := IGEN ('(a!# b!#), '(-2 -2), '(((0) 1 2)));
    WRITETNSR (TTRD, MYCAR (LEX), 1 . 1, 'T);
    FOR EACH X IN MYCDR (LEX) DO WRITETNSR (TTRD, X, (-1) . 1, 'T)
  >> ELSE <<
    MKTNSR!* (TTRD, '(-2 -2), '(((1) 1 2)), 'NIL, 'METRIC);
    LEX := ZPN (MYCAR (INDICETEN), MYCADR (INDICETEN), 1);
    WRITETNSR (TTRD, LIST (MYCAR (LEX), MYCADR (LEX)), 1 . 1, 'T);
    WRITETNSR (TTRD, LIST (MYCADDR (LEX), MYCADDDR (LEX)), (-1) . 1, 'T)
  >>;
  TTRDI := MYCAR (INVERT!* (LIST (TTRD)));
  PUT (TTRD, 'COORDS, 'NIL);
  PUT (TTRDI, 'COORDS, 'NIL);
  PUT (TTRD, '!#DBR, 0);
  PUT (TTRDI, '!#DBR, 0);
  FLAG (LIST (TTRDI), 'NODIR);
  PROTECT!* (TTRD, 'W);
  PROTECT!* (TTRDI, 'W);
  SETMET (TTRD);
  RETURN (TTRD . 1);
END;

NULLTETRAD := 'Z;	% default name for connection.
PUT ('NULLTETRAD, 'SIMPFN, 'NULLTETRAD!*);

% nulltetrad* computes a set of null-tetrad vectors for use as a
% tensor-frame connection from a set of spin matrices produced by
% spinmat (see spnr.red).

SYMBOLIC PROCEDURE NULLTETRAD!* (U);
BEGIN SCALAR LEX, LEX1, TTRD;
  TTRD := NEWNME (MYCAR (U), NULLTETRAD);
  GETCON (2);				% check for connection before creating 
  MKTNSR!* (TTRD, '(-2 -1), 'NIL, 'NIL, 'CONNECTION);
  LEX := IGEN ('(a!#), '(1), 'NIL);
  LEX1 := IGEN ('(a!# b!#), '(3 3), 'NIL);
 	% we copy each piece of the spin matrices over 
  EVALTNSR1 (TTRD, APPEND (MYCAR (LEX), '(a!#)),
    LIST ('RDR, GETCON (2), APPEND ('(a!#), MYCAR (LEX1))), 'NIL);
  EVALTNSR1 (TTRD, APPEND (MYCADR (LEX), '(a!#)),
    LIST ('RDR, GETCON (2), APPEND ('(a!#), MYCADDDR (LEX1))), 'NIL);
  EVALTNSR1 (TTRD, APPEND (MYCADDR (LEX), '(a!#)),
    LIST ('RDR, GETCON (2), APPEND ('(a!#), MYCADR (LEX1))), 'NIL);
  EVALTNSR1 (TTRD, APPEND (MYCADDDR (LEX), '(a!#)),
    LIST ('RDR, GETCON (2), APPEND ('(a!#), MYCADDR (LEX1))), 'NIL);
  PROTECT!* (TTRD, 'W);
  IF NOT INDEXED (MYCAR (CURRENTCONNECTION)) THEN SETCON (TTRD, 1);
  CLEANER ('NULLTETRAD);
  RETURN (TTRD . 1);
END;

GAMMA := 'GAM;
PUT ('GAMMA, 'SIMPFN, 'GAMMA!*);

% gamma* computes the gamma symbol in a tetrad frame.
% reference: General Relativity: An Einstein Centenary Survey,
% Chpt 7, pg 373-4

SYMBOLIC PROCEDURE GAMMA!* (U);
BEGIN SCALAR LEX, LEX1, FRME;
  FRME := MYCAR (U);
  LEX1 := GET (GETMET (1), 'GAMMA);	% see if it exists. (note name 
  IF NOT FRME AND INDEXED (LEX1) THEN RETURN (LEX1 . 1); %   on tensor metric)
  FRME := NEWNME (FRME, GAMMA);		% give it a name
  GETCON (1);				% see if connection is there 
  MKTNSR!* ((LEX1 := TMPNAMES ()), '(-2 -1 -1), '(((-1) 2 3)), '(), '());
  EVALTNSR1 (LEX1, '(a!# b!# c!#), 
    LIST ('PLUS,
     LIST ('RDR, GETCON (1), '(a!# b!# !#BR c!#)),
     LIST ('MINUS, 
     LIST ('RDR, GETCON (1), '(a!# c!# !#BR b!#)))), 'NIL);
  MKTNSR!* ((LEX := TMPNAMES ()), '(-2 -2 -2), '(((-1) 1 2)), '(), '());
  EVALTNSR1 (LEX, '(a!# c!# b!#),
    LIST ('TIMES, 
     LIST ('RDR, LEX1, '(b!# d!# e!#)),
     LIST ('RDR, GETCON (1), '(a!# (!*AT!* d!#))),
     LIST ('RDR, GETCON (1), '(c!# (!*AT!* e!#)))), 'NIL);
  MKTNSR!* (FRME, '(-2 -2 -2), '(((-1) 1 2)), '(), 'GAMMA);
  EVALTNSR1 (FRME, '(a!# b!# c!#), 
    LIST ('QUOTIENT, LIST ('PLUS,
      LIST ('RDR, LEX, '(a!# c!# b!#)),
      LIST ('RDR, LEX, '(c!# b!# a!#)),
      LIST ('MINUS,
      LIST ('RDR, LEX, '(b!# a!# c!#)))), 2), 'NIL);
  PROTECT!* (FRME, 'W);
  PUT (GETMET (1), 'GAMMA, FRME);	% store name on tensor metric
  CLEANER ('GAMMA);
  RETURN (FRME . 1);
END;

FRRIEMANN := 'FRRI;
PUT ('FRRIEMANN, 'SIMPFN, 'FRRIEMANN!*);

% frriemann* computes the fully covariant Riemann curvature tensor in a frame.

SYMBOLIC PROCEDURE FRRIEMANN!* (U);
BEGIN SCALAR FRME, LEX, LEX1;
  FRME := MYCAR (U);
  LEX := GET (GETMET (1), 'FRRIEMANN);	% see if it exists
  IF NOT FRME AND INDEXED (LEX) THEN RETURN (LEX . 1);
  FRME := NEWNME (FRME, FRRIEMANN);		% give it a name
  LEX1 := MYCAR (GAMMA!* ('NIL));
  LEX := LIST ('PLUS,
         LIST ('TIMES,
           LIST ('RDR, LEX1, '(a!# b!# d!# !#BR e!#)),
           LIST ('RDR, GETCON (1), '(c!# (!*AT!* e!#)))),
         LIST ('MINUS, LIST ('TIMES, 
           LIST ('RDR, LEX1, '(a!# b!# c!# !#BR e!#)),
           LIST ('RDR, GETCON (1), '(d!# (!*AT!* e!#))))),
         LIST ('TIMES,
           LIST ('RDR, LEX1, '((!*AT!* e!#) a!# d!#)),
           LIST ('RDR, LEX1, '(e!# b!# c!#))),  
         LIST ('MINUS, LIST ('TIMES, 
           LIST ('RDR, LEX1, '((!*AT!* e!#) a!# c!#)),
           LIST ('RDR, LEX1, '(e!# b!# d!#)))),  
         LIST ('TIMES,
           LIST ('RDR, LEX1, '(a!# b!# e!#)),
             LIST ('PLUS,
             LIST ('RDR, LEX1, '((!*AT!* e!#) c!# d!#)),
             LIST ('MINUS,
             LIST ('RDR, LEX1, '((!*AT!* e!#) d!# c!#))))));

  MKTNSR!* (FRME, '(-2 -2 -2 -2), '(((-1) 1 2)((-1) 3 4)((2) 1 3)), '(),
                   'FRRIEMANN);
  EVALTNSR1 (FRME, '(a!# b!# c!# d!#), LEX, 'NIL);
  PROTECT!* (FRME, 'W);
  PUT (GETMET (1), 'FRRIEMANN, FRME);	% save name on tensor metric
  IF NOT GET (FRME, 'TVALUE) THEN <<
    PRIN2 ("** this space is flat");
    TERPRI ()
    >>;
  CLEANER ('FRRIEMANN);
  RETURN (FRME . 1);
END;

FRRICCI := 'FRRIC;
PUT ('FRRICCI, 'SIMPFN, 'FRRICCI!*);

% frricci* computes the fully covariant Ricci tensor in a frame.

SYMBOLIC PROCEDURE FRRICCI!* (U);
BEGIN SCALAR FRME, LEX;
  FRME := MYCAR (U);
  LEX := GET (GETMET (1), 'FRRICCI);	% see if it exists
  IF NOT FRME AND INDEXED (LEX) THEN RETURN (LEX . 1);
  FRME := NEWNME (FRME, FRRICCI);	% give it a name
  GETCON (1);				% see if connection is there 
  LEX := LIST ('TIMES, LIST ('RDR, GETMET (-2), '(c!# d!#)),
        LIST ('RDR, MYCAR (FRRIEMANN!* ('NIL)), '(c!# a!# b!# d!#)));

  MKTNSR!* (FRME, '(-2 -2), '(((1) 1 2)), '(), 'FRRICCI);

  EVALTNSR1 (FRME, '(a!# b!#), LEX, 'NIL);
  PROTECT!* (FRME, 'W);
  IF NOT GET (FRME, 'TVALUE) THEN <<
    PRIN2 ("** this metric is a vacuum solution.");
    TERPRI ()
    >>;
  PUT (GETMET (1), 'FRRICCI, FRME);	% store name on tensor metric
  CLEANER ('FRRICCI);
  RETURN (FRME . 1);
END;

FRRICCISC := 'FRRICSC;
PUT ('FRRICCISC, 'SIMPFN, 'FRRICCISC!*!*);

% frriccisc** set up the call to frriccisc*

SYMBOLIC PROCEDURE FRRICCISC!*!* (U);
  FRRICCISC!* (MYCAR (U), MYCADR (U));

% frriccisc* computes the Ricci scalar from the frame version of the
% Ricci tensor. the result should come out the same as the tensor version.

SYMBOLIC PROCEDURE FRRICCISC!* (U, V);
BEGIN SCALAR EX1, LEX;
  IF (LEX := RESIMPSCALAR (V, MYCAR (FRRICCI!* ('NIL)), 'FRRICISC)) 
    THEN RETURN (LEX);
  EX1 := NEWNME (MYCAR (U), FRRICCISC);	% get a name to put it in
  GETMET (-2);				% check for metric 
%  PUT (EX1, 'SIMPFN, 'MKRDR);
%  FLAG (LIST (EX1), 'FULL);
%  PUT (EX1, 'INDEXED, 'SCALAR);	% make it scalar
%  PUT (EX1, 'INDICES, '(0));
%  INAMES := EX1 . INAMES;
  LEX := EVALTNSR1 (EX1, 'NIL, LIST ('TIMES,
        LIST ('RDR, GETMET (-2), '(a!# b!#)),
        LIST ('RDR, MYCAR (FRRICCI!* ('NIL)), '(a!# b!#))), 'NIL);
  CLEANER ('FRRICCISC);
  PUT (MYCAR (FRRICCI!* ('NIL)), 'FRRICCISC, LEX);  % put value on frame ricci 
  RETURN (MYCADR (SETK (EX1, LIST ('!*SQ, LEX, 'T))));
END;

FREINSTEIN := 'FREI;
PUT ('FREINSTEIN, 'SIMPFN, 'FREINSTEIN!*);

% freinstein* computes the fully covariant Einstein tensor in a frame.

SYMBOLIC PROCEDURE FREINSTEIN!* (U);
BEGIN SCALAR FRME, LEX;
  FRME := MYCAR (U);
  LEX := GET (GETMET (1), 'FREINSTEIN);	% see if it exists
  IF NOT FRME AND INDEXED (LEX) THEN RETURN (LEX . 1);
  FRME := NEWNME (FRME, FREINSTEIN);
  LEX :=  LIST ('PLUS, LIST ('RDR, MYCAR (FRRICCI!* ('NIL)), '(a!# b!#)),
        LIST ('MINUS, LIST ('TIMES, 
                       MK!*SQ (QUOTSQ (FRRICCISC!* ('NIL, 'NIL), 2 . 1)),
        LIST ('RDR, GETMET (2), '(a!# b!#)))));

  MKTNSR!* (FRME, '(-2 -2), '(((1) 1 2)), '(), 'FREINSTEIN);
  EVALTNSR1 (FRME, '(a!# b!#), LEX, 'NIL);
  PROTECT!* (FRME, 'W);
  PUT (GETMET (1), 'FREINSTEIN, FRME);	% store name on tensor metric
  CLEANER ('FREINSTEIN);
  RETURN (FRME . 1);
END;

FRWEYL := 'FRC;
PUT ('FRWEYL, 'SIMPFN, 'FRWEYL!*);
GLOBAL '(INDICETEN);

% frweyl* computes the fully covariant Weyl conformal curvature tensor in a
% frame.

SYMBOLIC PROCEDURE FRWEYL!* (U);
BEGIN SCALAR FRME, LEX, LEX1, LEX2;
  LEX := GET (GETMET (1), 'FRWEYL);	% see if it exists
  IF NOT FRME AND INDEXED (LEX) THEN RETURN (LEX . 1);
  LEX := MYCADR (INDICETEN) - MYCAR (INDICETEN) + 1;
  LEX2 := LEX - 2;
  LEX1 := (LEX - 1) * LEX2;
  FRME := MYCAR (U);
  FRME := NEWNME (FRME, FRWEYL);	% give it a name
  LEX1 := MK!*SQ (QUOTSQ (FRRICCISC!* ('NIL, 'NIL), LEX1 . 1));
  LEX := LIST ('PLUS,
        LIST ('RDR, MYCAR (FRRIEMANN!* ('NIL)), '(a!# b!# c!# d!#)),
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (2), '(a!# c!#)),
     LIST ('RDR, MYCAR (FRRICCI!* ('NIL)), '(b!# d!#))), LEX2),
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (2), '(b!# d!#)),
     LIST ('RDR, MYCAR (FRRICCI!* ('NIL)), '(a!# c!#))), LEX2),
      LIST ('MINUS,
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (2), '(b!# c!#)),
     LIST ('RDR, MYCAR (FRRICCI!* ('NIL)), '(a!# d!#))), LEX2)),
      LIST ('MINUS,
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (2), '(a!# d!#)),
     LIST ('RDR, MYCAR (FRRICCI!* ('NIL)), '(b!# c!#))), LEX2)),
      LIST ('MINUS,
     LIST ('TIMES, LIST ('RDR, GETMET (2), '(a!# c!#)),
                   LIST ('RDR, GETMET (2), '(b!# d!#)),
        LEX1)),
     LIST ('TIMES, LIST ('RDR, GETMET (2), '(a!# d!#)),
                   LIST ('RDR, GETMET (2), '(b!# c!#)),
        LEX1));
  MKTNSR!* (FRME, '(-2 -2 -2 -2), '(((-1) 1 2)((-1) 3 4)((2) 1 3)), '(),
                    'FRWEYL);
  EVALTNSR1 (FRME, '(a!# b!# c!# d!#), LEX, 'NIL);
  PROTECT!* (FRME, 'W);
  PUT (FRME, 'TYPE, 'FRWEYL);
  PUT (GETMET (1), 'FRWEYL, FRME);	% save name on tensor metric
  IF NOT GET (FRME, 'TVALUE) THEN <<
    PRIN2 ("** this space is conformally flat");
    TERPRI ()
  >>;
  CLEANER ('FRWEYL);
  RETURN (FRME . 1);
END;

;END;
