(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Transcript of Session
:[font = text; inactive; ]
This example comes from section 9.4.3.
This is probably of no use on the Macintosh, since the Notebook does this, among other things.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
Transcript::usage = "Transcript[filename] opens filename for a transcript
	of the current session. It clobbers $Post"
EndTranscript::usage = "EndTranscript[] closes the transcript opened with Transcript[]."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
`transcript=""
(*
:[font = input; initialization; ]
*)
Transcript[filename_String] := (
	transcript = OpenWrite[filename];
	If[ Head[transcript] =!= String, Return[transcript] ];
	$Post := ($Post := MakeTranscript; Identity);
	transcript
	)
(*
:[font = input; initialization; ]
*)
EndTranscript[] := (
	MakeTranscript;
	$Post =. ;
	Close[transcript]
	)
(*
:[font = input; initialization; ]
*)
GetInputForm[v_ValueList] :=
	Block[{input},
		input = MapAt[HoldForm, v, {1, 2}] [[1,2]];
		input = Characters[ToString[InputForm[input]]];
		input = Drop[input, {1, 9}]; (* HoldForm[ *)
		input = Drop[input, -1];     (* ]         *)
		StringJoin @@ input
	]
	
MakeTranscript :=
	Block[{input, output},
		input  = GetInputForm[Take[DownValue[In],  {-2}]];
		output = GetInputForm[Take[DownValue[Out], {-1}]];
		WriteString[transcript, "(* In[", $Line-1, "]=\n", input, "\n*)\n"];
		WriteString[transcript, "\n", output, "\n\n"];
		Identity
	]
(*
:[font = input; initialization; endGroup; ]
*)
End[]
Null
(*
^*)