(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Plot Utilities
:[font = text; inactive; ]
This example comes from subsection 11.1.2.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["Utilities`PlotUtilities`", "Graphics`Colors`"]
(*
:[font = input; initialization; ]
*)
ArgColor::usage = "ArgColor[z] gives a color value whose hue is proportional
	to the argument of the complex number z."
ArgShade::usage = "ArgShade[z] gives a gray level proportional
	to the argument of the complex number z."
(*
:[font = input; initialization; ]
*)
ColorCircle::usage = "ColorCircle[r, (light:1)] gives a color value whose hue
	is proportional to r (mod 2Pi) with lightness light."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
ArgColor[z_] := RGBColor[1,1,1]	/; z == 0.0
ArgColor[z_] := HSBColor[ N[(Pi + Arg[z])/(2Pi)], 1, 1 ]
(*
:[font = input; initialization; ]
*)
ArgShade[z_] := GrayLevel[1]	/; z == 0.0
ArgShade[z_] := GrayLevel[N[(Pi + Arg[z])/(2Pi)] ]
(*
:[font = input; initialization; ]
*)
ColorCircle[arg_, light_:1.0] :=
	Block[{ mh = 3.0 Mod[N[arg / Pi], 2.0], ind, frac, frac1, scale },
		ind = Floor[mh]; frac = mh - ind;
		scale = Max[ Min[light, 1.0], 0.0 ];
		frac1 = scale(1.0-frac); frac *= scale;
		Switch[ind,
			0,	RGBColor[scale, frac,   0.0],
			1,	RGBColor[frac1, scale,  0.0],
			2,	RGBColor[0.0,   scale,  frac],
			3,	RGBColor[0.0,   frac1,  scale],
			4,	RGBColor[frac,  0.0,    scale],
			5,	RGBColor[scale, 0.0,    frac1],
			6,	RGBColor[scale, frac,   0.0]
		]
	] /; NumberQ[N[arg]]
(*
:[font = input; initialization; ]
*)
ColorCircle[_, light_:1.0] := RGBColor[light, light, light]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[ArgColor, ArgShade, ColorCircle]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)