(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Counting Primes
:[font = text; inactive; ]
This example comes from subsection 4.1.2.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Demo
:[font = text; inactive; ]
PrimePi[x] counts the number of primes less than or equal to x.
:[font = text; inactive; ]
The 301st prime.
:[font = input; ]
PrimePi[1993]
:[font = text; inactive; ]
The number of primes less than 100,000
:[font = input; endGroup; ]
PrimePi[100000]
:[font = subsection; inactive; startGroup; Cclosed; ]
A Plot of PrimePi[]
:[font = text; inactive; ]
PrimePi[] is defined for any real number. We can there for plot it.
:[font = input; endGroup; endGroup; ]
Plot[PrimePi[xp], {xp, 0, 20}];
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
PrimePi::usage = "PrimePi[x] returns the number of primes <= x."
(*
:[font = input; initialization; ]
*)
Attributes[PrimePi] = {Listable}
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
PrimePi[x_] := 0 /; x < 2
(*
:[font = input; initialization; ]
*)
PrimePi[x_] :=
	Block[{`li, `n0, `n1, `m, `nx = N[x]},
		li = LogIntegral[nx];
		n0 = Floor[li - LogIntegral[Sqrt[nx]]];
		n1 = Ceiling[li];
		While[ n1-n0 > 1,
			m = Floor[(n0+n1)/2];                 (* midpoint *)
			If[ Prime[m] <= nx, n0 = m, n1 = m ]
		];
		n0
	] /; x >= 2
(*
:[font = input; initialization; endGroup; ]
*)
End[]
Null
(*
^*)