{ This is a demonstration of how you can combine the features of GRUTILS
  with the sprite toolkit SPRITES. By using the GRSPRITE unit you can
  easily display a background picture and animate on it.                 }

{ This program is a part of the SHAREWARE package called GRUTILS v2.0
  See GRUTILS.DOC and REGISTER.TXT for more information                  }


Program GrSprites_Demo;

Uses GrUtils,Sprites,GrSprite, Crt;

Var
   mx,my,b : Integer;
   c       : Integer;
   x       : Integer;
   y       : Integer;

Procedure LoadSprites;     { Loads the four sprites into memory }
Type
    SpriteDataType = record
                           FileName : string[20];
                           x, y,
                           w, h : integer;
                     End;
Const
     SpriteData : Array [1..4] of SpriteDataType =
               ((FileName:'1.CEL';x:0;y:83;w:11;h:27),
                (FileName:'2.CEL';x:0;y:0;w:19;h:27),
                (FileName:'3.CEL';x:0;y:0;w:13;h:27),
                (FileName:'4.CEL';x:0;y:0;w:20;h:27));
Var
  i : byte;

Begin
     For i := 1 To 4 Do
         Begin
              With SpriteData[i] Do
                   Begin
                        LoadCEL(FileName, addr(Sprite[i].SpriteData));
                        Sprite[i].w := w; Sprite [i].h := h;
                        Sprite[i].x := x; Sprite[i].y := y;
                   End;
         End;
     Sprite[1].Active := True;
     For i := 2 To 4 Do Sprite[i].Active := False;
End;

Procedure Animate;     { Changes the active sprite and its x- and }
                       { y-coordinates, making the man walk       }
Var
   i   : Integer;
   col : Integer;

Begin
     Inc(x,4);           { Makes him move to the right }
     Peek(x,y+27,col);   { Read color under his feed }
     If Col <> 0 Then    { If he is on the stairs, go down ! }
        Begin
             Repeat
                   Inc(y);
                   Peek(x,y+27,col);
             Until col = 0;
        End;
     For i := 1 To 4 Do
         Begin
              Sprite[i].Active := False;
              Sprite[i].X      := x;
              Sprite[i].Y      := y;
         End;
     HideSprites;
     Inc(c);
     If c > 6 Then c := 1;
     If c = 1 Then Sprite[1].Active := True;
     If c = 2 Then Sprite[2].Active := True;
     If c = 3 Then Sprite[1].Active := True;
     If c = 4 Then Sprite[3].Active := True;
     If c = 5 Then Sprite[4].Active := True;
     If c = 6 Then Sprite[3].Active := True;
End;

Procedure UpdateMouse(Var x,y,b : Integer);  { Reports mouse movment }
Begin                                        { and makes it visible  }
     MouseOn;
     Mouse(x,y,b);
     MoveMouse(x,y);
End;

Procedure Start;               { Repeat Until the red arrow is pressed }
Var
   mx,my,b,col : Integer;

Begin
     c := 0;
     x := 0;
     y := 83;
     DrawSprites;
     ShowVirtualScreen;
     MouseOn;
     Repeat
           Mouse(mx,my,b);
           Peek(mx-1,my-1,col);
     Until (b=1) And (col=35);
End;

Procedure InitScreen;     { Textmode screen }
Var
   Ch : Char;

Begin
     Init(3);
     CursorOff;
     WriteCenter(2,4,'GRSPDEMO');
     WriteAT(12,5,green,'This is a demostration of the GRSPRITE units for use');
     WriteAT(12,6,green,'with GRUTILS and SPRITES. As you will see theese tree');
     WriteAT(12,7,green,'units compined is a very powerful tool to be used in');
     WriteAT(12,8,green,'games or animations.');
     WriteAT(12,9,green,'The scenery you are about to see is actualy a part of');
     WriteAT(12,10,green,'a game which is under construction right now.');
     WriteAT(12,12,green,'Use the mouse to push the red cursor to make the');
     WriteAT(12,13,green,'sprite move.');
     WriteCenter(25,red,'Press any key to begin');
     Repeat Until KeyPressed;
     Ch := ReadKey;
End;

Begin
     InitScreen;                  { Displays textmode introduction screen }
     LoadSprites;                 { Loads the four sprites }
     InitMcga;                    { Initializes mode 13h }
     LoadPcx('SCENERY.PCX');      { Loads backroundpicture SCENERY.PCX }
     StoreScreen(Virtual_Screen); { Stores screen as Virtual_Screen    }
     Start;                       { Waits until you are ready }
     Repeat
           MouseOff;              { Hides the mousecursur so it dont disturb the putting of the sprites }
           Animate;               { Choses the right sprite }
           DrawSprites;           { Draws the sprite in memory }
           ShowVirtualScreen;     { Shows background with sprite(s) }
           UpdateMouse(mx,my,b);  { Updates mouse movement *** }
           Delay(100);            { Delays for a moment so the man dont run, but walks }
     Until x > 300;               { Keep on going until he reaches the right end }
     FadeDownAll(20);             { Fades all colors to black }
     Init(3);                     { Back in textmode 3h again }
End.

{ *** When you are using a sprite toolkit like SPRITE it constantly
      updates the screen. If you only use the normal mouse(Var x,y,b);
      The cursor will be overwritten by the background picture every
      time ShowVirtualScreen is called, therefor you need to constantly
      put the mousecursor ontop of the picture. The Updatemouse procedure
      will do this for you. You will notice some flickering of the cursor
      when something is animated, I have not been able to remove this, so
      if anyone thinks of something smart please let me know }
