
Unit BreakNow;
{
 This Unit will intercept hardware interrupt $9 and check for a Ctrl-Break.
 If the interrupt does not contain a Ctrl-Break the preceding Int9 is called.
 If Ctrl-Break was pressed we call Turbo's int23 handler to stop execution
 of the program, while still executing the ExitProcs.
}
interface

Uses DOS,CRT;

  { No interface }

implementation

Var
  Int23,
  OldExit,
  OldKBD : pointer;

{ This procedure will jump from an ISR to the ISR vector passed }

procedure JmpOldISR(OldISR: pointer);
  inline($5B/$58/$87/$5E/$0E/$87/$46/$10/$89/
         $EC/$5D/$07/$1F/$5F/$5E/$5A/$59/$CB);

{$F+}
procedure Key_ISR( Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP:word );
interrupt;
Begin
  if CheckBreak and ((Mem[0000:$0417] and 4) = 4) and (Port[$60] = 70) then
     Begin
       inline($E4/$61/$8A/$E0/$0C/$80/$E6/$61/   { Clean up as the    }
              $86/$E0/$E6/$61/$B0/$20/$E6/$20);  { Bios would         }
       JmpOldISR( Int23 );   {Jump to current Int23 handler (turbo's) }
     end;
  JmpOldISR( OldKBD );       {Jump to Old Keyboard handler }
End;

Procedure Exitit;
Begin
  ExitProc := OldExit;       { Restore Old ExitProc pointer }
  SetIntVec( 9, OldKBD );    { Restore Old Int9 Handler     }
end;
{$F-}

Begin
  OldExit := ExitProc;       { Save old ExitProc pointer }
  ExitProc := @Exitit;       { Set new ExitProc pointer  }
  GetIntVec( $23, Int23 );   { Get Current Int23 Vector  }
  GetIntVec( 9, OldKBD );    { Get Current Int9  Vector  }
  SetIntVec( 9, @Key_ISR );  { Set Int9 to our routine   }
end.
