`` Array of Bits
`` Using integers for storage

`` www.scriptol.org
`` Requires a Scriptol Compiler
`` 2005



class ArrayOfBits

	int[] bits		`the array of integers
	int size			`the number of bits
	constant int CBIT = 32
	
	`Create the array of bits as a string
	
	void ArrayOfBits(int s)
		int i = (s + CBIT - 1) / CBIT
		for int j in 0 -- i let bits.push(0)
		size = s
	return	

	` Return a bit at pos

	boolean get(int pos)
		int i = pos / CBIT
		int bit = bits[i]
		int mask = 1 << (pos mod CBIT)
		bit = bit & mask
	return bit <> 0	

	`Change a bit to 0 or 1 at pos according to value

	void set(int pos, boolean value)
		int i = pos / CBIT
		int b = bits[i]
		int mask = 1 << (pos mod CBIT)
		if value = true
			b  = b | mask
		else    
			b  = b & ~mask
		/if
		bits[i] = b
	return

	`Invert the value of a bit, true become false and conversely

	void flip(int pos)
		int i = pos / CBIT
		int b = bits[i]
		int mask =  1 << (pos mod CBIT)      
		b =  b ^ mask         
		bits[i] = b
	return
	
	`Return the string of bits as an array of integers
	
	array toArray()
		array x
		for int i in 0 -- size
			boolean j = get(i)
			if j = true
				x.push(1)
			else
				x.push(0)
			/if	
		/for	
	return x				

/class



// demo

ArrayOfBits aob = ArrayOfBits(14)
aob.set(5, true)

aob.flip(8)



array y = aob.toArray()
print "Only 5 and 8 must be true:"
y.display()