//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ZylBurner"
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnAddDirectoryClick(TObject *Sender)
{
  if (DirectoryListBox->Directory != "")
    ListBox->Items->Add(DirectoryListBox->Directory);
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnAddFileClick(TObject *Sender)
{
  if (FileListBox->FileName != "")
    ListBox->Items->Add(FileListBox->FileName);
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnRemoveClick(TObject *Sender)
{
  if (ListBox->ItemIndex >= 0)
    ListBox->Items->Delete(ListBox->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnBrowseClick(TObject *Sender)
{
  if (OpenDialog->Execute())
    efImage->Text = OpenDialog->FileName;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnBurnClick(TObject *Sender)
{
  ZylBurner->NeroCmdLocation = Trim(efNeroPath->Text);
  if (gbMedia->ItemIndex == 1)
    ZylBurner->DVD = True;
  else
    ZylBurner->DVD = False;

  ZylBurner->DiskType = TDiskType(gbDisk->ItemIndex);

  ZylBurner->Files->Clear();
  for (int i = 0; i < ListBox->Items->Count; i++)
    ZylBurner->Files->Add(ListBox->Items->Strings[i]);

  if (Trim(efDrive->Text) != "")
    ZylBurner->Burn(efDrive->Text[1]);
  else
    ShowMessage("Please enter the drive letter.");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnEraseClick(TObject *Sender)
{
  ZylBurner->NeroCmdLocation = Trim(efNeroPath->Text);
  if (Trim(efDrive->Text) != "")
    ZylBurner->Erase(efDrive->Text[1], chkFull->Checked);
  else
    ShowMessage("Please enter the drive letter.");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnEjectClick(TObject *Sender)
{
  ZylBurner->NeroCmdLocation = Trim(efNeroPath->Text);
  if (Trim(efDrive->Text) != "")
    ZylBurner->Eject(efDrive->Text[1]);
  else
    ShowMessage("Please enter the drive letter.");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnBurnImgClick(TObject *Sender)
{
  ZylBurner->NeroCmdLocation = Trim(efNeroPath->Text);
  if (FileExists(Trim(efImage->Text)))
  {
    if (Trim(efDrive->Text) != "")
      ZylBurner->BurnImage(Trim(efImage->Text), efDrive->Text[1]);
    else
      ShowMessage("Please enter the drive letter.");
  }
  else
  {
    ShowMessage("File not found.");
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylBurnerSuccess(TObject *Sender)
{
  ShowMessage("Success.");        
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylBurnerError(TObject *Sender, int ErrorCode)
{
  ShowMessage("Error.");        
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::btnBrowse1Click(TObject *Sender)
{
  if (OpenDialog->Execute())
    efNeroPath->Text = OpenDialog->FileName;
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
  efNeroPath->Text = ZylBurner->NeroCmdLocation;        
}
//---------------------------------------------------------------------------

