/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import unity.io.FileManager;
import unity.operators.BufferOperator;
import unity.operators.DualHashTable;
import unity.operators.Operator;
import unity.predicates.EquiJoinPredicate;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.relational.TupleXJoin;

public class XJoin
extends Operator {
    private DualHashTable hashTable;
    private int numPartitions;
    private static int MAX_INT = 999999999;
    private boolean OPTIMIZATION_ON = true;
    private EquiJoinPredicate predicate;
    private Relation[] schemas;
    private boolean isMNJoin;
    private boolean[] bufferedInput;
    private boolean bothInputsBuffered;
    private Tuple currentTuple;
    private int currentInput;
    private boolean endLeft;
    private boolean endRight;
    private int timestamp;
    private boolean processingProbe;
    private boolean processingTimestampProbe;
    private boolean processingInput;
    private ArrayList probeMatches;
    private int currentProbeIndex;
    private int currentPartitionIndex;
    private int partitionFileIndex;
    private boolean processingProbeInput;
    private BufferedInputStream probeFile;
    private boolean cleanupMemoryProbe;
    private ArrayList rightTuples;
    private int currentRightIndex;
    private LinkedList[][] timestampList;
    private int[][] lastDepartures;
    private boolean blocked;
    private boolean midBlockProcessing;
    private int tester;
    private int ioCounter;

    public XJoin(Operator[] in, EquiJoinPredicate p, int bsize, int bfr, int numpart, boolean MNJoin) {
        super(in, bfr, bsize);
        this.numPartitions = numpart;
        this.isMNJoin = MNJoin;
        this.predicate = p;
    }

    public void init() throws IOException {
        this.input[0].init();
        this.input[1].init();
        this.schemas = new Relation[2];
        this.schemas[0] = this.input[0].getOutputRelation();
        this.schemas[1] = this.input[1].getOutputRelation();
        Relation out = new Relation(this.schemas[0]);
        out.mergeRelation(this.schemas[1]);
        this.setOutputRelation(out);
        this.bufferedInput = new boolean[2];
        this.bufferedInput[0] = this.input[0].isBuffered();
        this.bufferedInput[1] = this.input[1].isBuffered();
        this.bothInputsBuffered = this.bufferedInput[0] && this.bufferedInput[1];
        this.hashTable = new DualHashTable(this.BUFFER_SIZE, this.numPartitions, this.BLOCKING_FACTOR, this.schemas[0], this.schemas[1], this.predicate, this.OPTIMIZATION_ON && !this.isMNJoin);
        this.endLeft = false;
        this.endRight = false;
        this.timestamp = 1;
        this.processingInput = true;
        this.processingProbe = false;
        this.processingTimestampProbe = false;
        this.tester = 0;
        this.blocked = false;
        this.midBlockProcessing = false;
        this.timestampList = new LinkedList[2][this.numPartitions];
        this.lastDepartures = new int[2][this.numPartitions];
        int i = 0;
        while (i < this.numPartitions) {
            this.timestampList[0][i] = new LinkedList();
            this.timestampList[1][i] = new LinkedList();
            this.lastDepartures[0][i] = -1;
            this.lastDepartures[1][i] = -1;
            ++i;
        }
    }

    public void close() throws IOException {
        this.hashTable.clear();
        System.out.println("Statistics:");
        int ia = this.hashTable.getInsertsAvoided();
        int td = this.hashTable.getTuplesDiscarded();
        System.out.println("Inserts avoided: " + ia + " Tuples discarded: " + td + " Total I/Os saved: " + 2 * (ia + td));
    }

    public boolean alreadyMerged(int arrive, int depart, int pArrive, int pDepart, int part, int source) {
        for (int i = this.timestampList[source][part].size() - 1; i >= 0; --i) {
            Timing t = (Timing)this.timestampList[source][part].get(i);
            if (pDepart <= t.lastDeparture) {
                if (t.probeTime <= arrive || t.probeTime >= depart) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Tuple next() throws IOException {
        while (true) {
            String fileName;
            if (this.processingProbe) {
                if (this.currentProbeIndex < this.probeMatches.size()) {
                    Tuple match = (Tuple)this.probeMatches.get(this.currentProbeIndex++);
                    if (this.currentInput == 1) {
                        return this.outputJoinTuple(match, this.currentTuple);
                    }
                    return this.outputJoinTuple(this.currentTuple, match);
                }
                this.processingProbe = false;
            }
            if (this.processingTimestampProbe) {
                TupleXJoin probeTuple = (TupleXJoin)this.currentTuple;
                while (this.currentProbeIndex < this.probeMatches.size()) {
                    TupleXJoin match = (TupleXJoin)this.probeMatches.get(this.currentProbeIndex++);
                    int leftATS = match.getArrivalTimestamp();
                    int rightATS = probeTuple.getArrivalTimestamp();
                    int leftDTS = match.getDepartureTimestamp();
                    int rightDTS = probeTuple.getDepartureTimestamp();
                    if (rightDTS >= leftATS && leftDTS >= rightATS) continue;
                    if (this.blocked && !this.alreadyMerged(leftATS, leftDTS, rightATS, rightDTS, this.currentPartitionIndex, 1)) {
                        Tuple t = this.outputJoinTuple(match, this.currentTuple);
                        return t;
                    }
                    if (this.blocked || this.alreadyMerged(leftATS, leftDTS, rightATS, rightDTS, this.currentPartitionIndex, 1) || this.alreadyMerged(rightATS, rightDTS, leftATS, leftDTS, this.currentPartitionIndex, 0)) continue;
                    Tuple t = this.outputJoinTuple(match, this.currentTuple);
                    return t;
                }
                this.processingTimestampProbe = false;
            }
            if (this.blocked) {
                this.processingInput = false;
            }
            if (this.processingInput) {
                if (!this.readInputTuple()) {
                    this.processingInput = false;
                    this.blocked = false;
                    int numOutput = this.hashTable.close(DualHashTable.IS_FROZEN, this.timestamp);
                    this.incrementTupleIOs(numOutput);
                    this.incrementPageIOs((int)Math.ceil((double)numOutput / (double)this.BLOCKING_FACTOR));
                    this.currentPartitionIndex = -1;
                    if (this.initPartition()) continue;
                    return null;
                }
                this.probeMatches = this.hashTable.probe(this.currentTuple, this.currentInput);
                this.currentProbeIndex = 0;
                this.processingProbe = this.probeMatches != null;
                int numOutput = this.hashTable.insert(this.currentTuple, this.currentInput, this.OPTIMIZATION_ON && this.processingProbe && !this.isMNJoin);
                this.incrementTupleIOs(numOutput);
                this.incrementPageIOs(numOutput / this.BLOCKING_FACTOR);
                if (!this.hashTable.hasOverflow()) continue;
                this.largestFlush();
                continue;
            }
            if (this.blocked) {
                if (this.midBlockProcessing) {
                    if (!this.currentTuple.read(this.probeFile)) {
                        ++this.partitionFileIndex;
                    } else {
                        this.incrementTupleIOs();
                        if (this.ioCounter-- == 0) {
                            this.ioCounter = this.BLOCKING_FACTOR - 1;
                            this.incrementPageIOs();
                        }
                        this.probeMatches = this.hashTable.probe(this.currentTuple, 1);
                        this.currentProbeIndex = 0;
                        this.processingTimestampProbe = this.probeMatches != null;
                        continue;
                    }
                    FileManager.closeFile(this.probeFile);
                    ArrayList fileList = this.hashTable.getPartitionFileNames(1, this.currentPartitionIndex);
                    if (this.partitionFileIndex < fileList.size()) {
                        fileName = (String)fileList.get(this.partitionFileIndex);
                        this.probeFile = FileManager.openInputFile(fileName);
                        this.currentTuple = new TupleXJoin(this.schemas[1]);
                        this.ioCounter = this.BLOCKING_FACTOR - 1;
                        continue;
                    }
                    this.midBlockProcessing = false;
                    this.blocked = false;
                    this.processingInput = true;
                    Timing t = new Timing(this.lastDepartures[1][this.currentPartitionIndex], this.timestamp++);
                    this.timestampList[1][this.currentPartitionIndex].add(t);
                    continue;
                }
                this.currentPartitionIndex = this.choosePartition();
                if (this.currentPartitionIndex == -1) {
                    this.blocked = false;
                    this.processingInput = true;
                    continue;
                }
                this.currentTuple = new TupleXJoin(this.schemas[1]);
                this.midBlockProcessing = true;
                this.partitionFileIndex = 0;
                ArrayList fileList = this.hashTable.getPartitionFileNames(1, this.currentPartitionIndex);
                fileName = (String)fileList.get(this.partitionFileIndex);
                this.probeFile = FileManager.openInputFile(fileName);
                continue;
            }
            if (this.cleanupMemoryProbe) {
                this.probeMatches = null;
                while (this.currentRightIndex < this.rightTuples.size()) {
                    this.currentTuple = (Tuple)this.rightTuples.get(this.currentRightIndex++);
                    this.probeMatches = this.hashTable.probe(this.currentTuple, 1);
                    if (this.probeMatches == null) continue;
                }
                if (this.probeMatches == null) {
                    this.cleanupMemoryProbe = false;
                } else {
                    this.processingTimestampProbe = true;
                    this.currentProbeIndex = 0;
                    continue;
                }
            }
            if (this.processingProbeInput) {
                if (!this.currentTuple.read(this.probeFile)) {
                    this.processingProbeInput = false;
                    ++this.partitionFileIndex;
                    FileManager.closeFile(this.probeFile);
                } else {
                    this.incrementTupleIOs();
                    if (this.ioCounter-- == 0) {
                        this.ioCounter = this.BLOCKING_FACTOR - 1;
                        this.incrementPageIOs();
                    }
                    this.probeMatches = this.hashTable.probe(this.currentTuple, 1);
                    this.currentProbeIndex = 0;
                    this.processingTimestampProbe = this.probeMatches != null;
                    continue;
                }
            }
            if (this.partitionFileIndex >= this.hashTable.getNumFiles(1, this.currentPartitionIndex) && !this.initPartition()) {
                return null;
            }
            ArrayList fileList = this.hashTable.getPartitionFileNames(1, this.currentPartitionIndex);
            if (this.partitionFileIndex >= fileList.size()) continue;
            fileName = (String)fileList.get(this.partitionFileIndex);
            this.probeFile = FileManager.openInputFile(fileName);
            this.processingProbeInput = true;
            this.currentTuple = new TupleXJoin(this.schemas[1]);
            this.ioCounter = this.BLOCKING_FACTOR - 1;
        }
    }

    public int choosePartition() {
        int max = 0;
        int maxIndex = -1;
        int p = 0;
        while (p < this.numPartitions) {
            if (this.hashTable.getPartitionTupleCount(0, p) * this.hashTable.getNumFiles(1, p) > max) {
                max = this.hashTable.getPartitionTupleCount(0, p) * this.hashTable.getNumFiles(1, p);
                maxIndex = p;
            }
            ++p;
        }
        return maxIndex;
    }

    private boolean initPartition() throws IOException {
        ++this.currentPartitionIndex;
        while (this.currentPartitionIndex < this.numPartitions && this.hashTable.getNumFiles(0, this.currentPartitionIndex) == 0 && this.hashTable.getNumFiles(1, this.currentPartitionIndex) == 0) {
            this.hashTable.clear(0, this.currentPartitionIndex);
            this.hashTable.clear(1, this.currentPartitionIndex);
            ++this.currentPartitionIndex;
        }
        if (this.currentPartitionIndex >= this.numPartitions) {
            return false;
        }
        ArrayList fileList = this.hashTable.getPartitionFileNames(0, this.currentPartitionIndex);
        TupleXJoin leftT = new TupleXJoin(this.schemas[0]);
        int i = 0;
        while (i < fileList.size()) {
            String fileName = (String)fileList.get(i);
            BufferedInputStream buildFile = FileManager.openInputFile(fileName);
            int count = 0;
            while (leftT.read(buildFile)) {
                ++count;
                this.hashTable.insert(new TupleXJoin(leftT), 0, false);
            }
            FileManager.closeFile(buildFile);
            this.incrementTupleIOs(count);
            this.incrementPageIOs((int)Math.ceil((double)count / (double)this.BLOCKING_FACTOR));
            ++i;
        }
        this.processingProbeInput = false;
        this.cleanupMemoryProbe = true;
        this.rightTuples = this.hashTable.getPartitionTuples(1, this.currentPartitionIndex);
        this.currentRightIndex = 0;
        this.partitionFileIndex = 0;
        return true;
    }

    private void largestFlush() throws IOException {
        DualHashTable.PartitionInfo[] partitions = this.hashTable.getPartitionInfo();
        int flushSize = 1;
        int flushIndex = -1;
        int source = -1;
        int i = 0;
        while (i < this.numPartitions) {
            int partIndex = this.numPartitions + i;
            if (partitions[i].getNumTuples() > flushSize) {
                flushSize = partitions[i].getNumTuples();
                flushIndex = i;
                source = 0;
            }
            if (partitions[partIndex].getNumTuples() > flushSize) {
                flushSize = partitions[partIndex].getNumTuples();
                flushIndex = i;
                source = 1;
            }
            ++i;
        }
        this.hashTable.flush(source, flushIndex, DualHashTable.IS_EXPANDING, this.timestamp, false, null, true);
        this.lastDepartures[source][flushIndex] = this.timestamp++;
        this.incrementTupleIOs(flushSize);
        this.incrementPageIOs((int)Math.ceil((double)flushSize / (double)this.BLOCKING_FACTOR));
    }

    private boolean readInputTuple() throws IOException {
        ++this.tester;
        this.blocked = this.tester == 150000 || this.tester == 160001 || this.tester == 160002 || this.tester == 170000;
        this.currentInput = (this.currentInput + 1) % 2;
        if (this.currentInput == 0 && this.endLeft) {
            this.currentInput = 1;
        }
        if (this.currentInput == 1 && this.endRight) {
            this.currentInput = 0;
        }
        if (this.bothInputsBuffered) {
            BufferOperator op = (BufferOperator)this.input[this.currentInput];
            int otherInput = (this.currentInput + 1) % 2;
            BufferOperator op2 = (BufferOperator)this.input[otherInput];
            while (op.endInput() || !op.hasNext()) {
                if (!op2.endInput() && op2.hasNext()) {
                    this.currentInput = otherInput;
                    break;
                }
                if (op.endInput() && op2.endInput()) {
                    return false;
                }
                Thread.yield();
            }
        }
        this.currentTuple = this.input[this.currentInput].next();
        if (this.currentTuple == null) {
            if (this.currentInput == 0) {
                System.out.println("Finished left input at: " + this.timestamp);
                this.endLeft = true;
                if (this.OPTIMIZATION_ON) {
                    this.hashTable.setLeftInputFinished(true);
                    int tuplesRemoved = this.hashTable.clearLeftFinished();
                    System.out.println("After left input finished removed tuples from hash table (right-side): " + tuplesRemoved);
                }
            } else {
                System.out.println("Finished right input at: " + this.timestamp);
                this.endRight = true;
            }
            if (this.endLeft && this.endRight) {
                System.out.println("Finished all input at: " + this.timestamp);
                return false;
            }
            return this.readInputTuple();
        }
        this.currentTuple = new TupleXJoin(this.currentTuple, this.timestamp, MAX_INT);
        ++this.timestamp;
        this.incrementTuplesRead();
        return true;
    }

    private Tuple outputJoinTuple(Tuple left, Tuple right) {
        Tuple t = new Tuple(left, right, this.getOutputRelation());
        this.incrementTuplesOutput();
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("XJOIN: ");
        sb.append(this.predicate.toString(this.schemas[0], this.schemas[1]));
        sb.append("   (BufferSizeInTuples=" + this.BUFFER_SIZE * this.BLOCKING_FACTOR + ")");
        return sb.toString();
    }

    private class Timing {
        public int lastDeparture;
        public int probeTime;

        public Timing(int a, int b) {
            this.lastDeparture = a;
            this.probeTime = b;
        }
    }
}

