/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import unity.functions.Expression;
import unity.operators.Operator;
import unity.operators.ProjectionList;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class Projection
extends Operator {
    protected Expression[] expressionList;
    private Operator input;

    public Projection(Operator in, Expression[] exprList, Relation outputRelation) {
        super(new Operator[]{in}, 0, 0);
        this.input = in;
        this.expressionList = exprList;
        this.setOutputRelation(outputRelation);
    }

    public Projection(Operator in, ProjectionList plist) {
        super(new Operator[]{in}, 0, 0);
        this.input = in;
        this.outputRelation = new Relation(new Attribute[plist.getNumAttributes()]);
        this.expressionList = plist.buildExpressionList(this.outputRelation);
    }

    public void init() throws IOException {
        this.input.init();
    }

    public Tuple next() throws IOException {
        Tuple inTuple = this.input.next();
        this.incrementTuplesRead();
        if (inTuple == null) {
            return null;
        }
        Object[] vals = new Object[this.expressionList.length];
        int i = 0;
        while (i < this.expressionList.length) {
            if (this.expressionList[i] != null) {
                vals[i] = this.expressionList[i].evaluate(inTuple);
            }
            ++i;
        }
        this.incrementTuplesOutput();
        return new Tuple(vals, this.getOutputRelation());
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("PROJECT: ");
        sb.append(this.expressionList[0].toString(this.input.getOutputRelation()));
        int i = 1;
        while (i < this.expressionList.length) {
            sb.append(", " + this.expressionList[i].toString(this.input.getOutputRelation()));
            ++i;
        }
        return sb.toString();
    }
}

