from pychartdir import *


def shadowpie(angle, filename) :

	#The data for the pie chart
	data = [ 25, 18, 15, 12, 8, 30, 35 ]

	#First, create a PieChart of size 100 pixels x 110 pixels
	c = PieChart(100, 110)

	#Set the center of the pie at (50, 55) and the radius to 36 pixels
	c.setPieSize(50, 55, 36)

	#Set the depth, tilt angle and 3D mode of the 3D pie 
	#(-1 means auto depth, "true" means the 3D effect is in shadow mode)
	c.set3D(-1, angle, 1)

	#Add a title showing the tilt angle
	c.addTitle("Shadow @ %d deg" % angle, "arial.ttf", 8)

	#Set the pie data and the pie labels
	c.setData(data)

	#Disable the sector labels by setting the color to transparent
	c.setLabelStyle("", 8, Transparent)

	#output the chart
	c.makeChart(filename)


def main() :

	shadowpie(45, "shadow45pie.png")
	shadowpie(135, "shadow135pie.png")
	shadowpie(225, "shadow225pie.png")
	shadowpie(315, "shadow315pie.png")


if __name__ == '__main__':
    main()