.code
;
; ****************************
; *****  %_div.DCOMPLEX  *****  z3 = z1 / z2
; ****************************
;
; in:	eax -> z3 (result)
;	esi -> z1
;	edi -> z2
; out:	eax -> z3 (result)
;
; destroys: nothing
;
;	   Re(z1) * Re(z2) + Im(z1) * Im(z2)
; Re(z3) = ---------------------------------
;	   Re(z2) * Re(z2) + Im(z2) * Im(z2)
;
;	   Im(z1) * Re(z2) - Im(z2) * Re(z1)
; Im(z3) = ---------------------------------
;	   Re(z2) * Re(z2) + Im(z2) * Im(z2)
;

%_div.DCOMPLEX:
fld	q[esi]												;calculate real part of quotient
fld	q[edi]
fmul
fld	q[esi+8]
fld	q[edi+8]
fmul
fadd															; st0 = numerator
fld	q[edi]
fld	st0
fmul
fld	q[edi+8]
fld	st0
fmul
fadd															; st0 = denominator, st1 = numerator
fst	st2														; save denominator for later
fdiv
fstp	q[eax]											; store real part of quotient
fld	q[esi+8] 											; calculate imaginary part of quotient
fld	q[edi]
fmul
fld	q[edi+8]
fld	q[esi]
fmul
fsub															; st0 = numerator, st1 = denominator
fdivr
fstp	q[eax+8] 										; store imaginary part of quotient
ret

