.code
;
; ****************************
; *****  %_mul.DCOMPLEX  *****  z3 = z1 * z2
; ****************************
;
; in:	eax -> z3 (result)
;	esi -> z1
;	edi -> z2
; out:	eax -> z3 (result)
;
; destroys: nothing
;
; Re(z3) = Re(z1) * Re(z2) - Im(z1) * Im(z2)
; Im(z3) = Re(z1) * Im(z2) + Im(z1) * Re(z2)
;
%_mul.DCOMPLEX:
fld	q[esi]												; calculate real part of product
fld	q[edi]
fmul
fld	q[esi+8]
fld	q[edi+8]
fmul
fsub
fstp	q[eax]
fld	q[esi]												; calculate imaginary part of product
fld	q[edi+8]
fmul
fld	q[esi+8]
fld	q[edi]
fmul
fadd
fstp	q[eax+8]
ret
