/* -*- C -*-
 *
 * Program:	ximap
 * File:        search.h -- performing a search on a mailbox.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_search_h
#define __ximap_search_h

extern void createSearchPanel(/* MAILSTATUS* */);
extern void addSearchActions();

enum _MAYBEBOTH { XB_SET, XB_UNSET, XB_EITHER };
typedef enum _MAYBEBOTH MAYBEBOTH;


#define SEEN  " SEEN"
#define UNSEEN " UNSEEN"
#define DELETED " DELETED"
#define UNDELETED " UNDELETED"
#define RECENT " RECENT"
#define OLD " OLD"
#define ANSWERED " ANSWERED"
#define UNANSWERED " UNANSWERED"
#define FLAGGED " FLAGGED"
#define UNFLAGGED " UNFLAGGED"

#define BEFORE " BEFORE"
#define SINCE  " SINCE"
#define ON     " ON"

#define ALL    "ALL"

#define SPACE " "
#define QUOTE "\""

/**** These should be used only in Search.c at the moment */

#define XB_SEEN_YES          "seenYes"
#define XB_SEEN_NO           "seenNo"
#define XB_SEEN_EITHER       "seenEither"
#define XB_ANSWERED_YES      "answeredYes"
#define XB_ANSWERED_NO       "answeredNo"
#define XB_ANSWERED_EITHER   "answeredEither"
#define XB_RECENT_YES        "recentYes"
#define XB_RECENT_NO         "recentNo"
#define XB_RECENT_EITHER     "recentEither"
#define XB_DELETED_YES       "deletedYes"
#define XB_DELETED_NO        "deletedNo"
#define XB_DELETED_EITHER    "deletedEither"
#define XB_FLAGGED_YES       "flaggedYes"
#define XB_FLAGGED_NO        "flaggedNo"
#define XB_FLAGGED_EITHER    "flaggedEither"



#endif /*__ximap_search_h */
