/* -*- C -*-
 *
 * Program:	ximap
 * File:        modal.c -- confirmation and warning dialogs.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Text.h>

#include <X11/Xmu/Converters.h>

#include "Client/osdep.h"
#include "Client/misc.h"

static void confirmYes();
static void confirmNo();
static void confirmYesAct();
static void confirmNoAct();

typedef enum { CONFIRM_WAIT, CONFIRM_YES, CONFIRM_NO } XmsConfirmState;

static XtActionsRec confirm_actions[] =
{
  { "confirm_yes",   confirmYesAct },
  { "confirm_no",    confirmNoAct },
};

static XmsConfirmState confirmState;

extern XtAppContext app_context;

void addConfirmActions(ac)
     XtAppContext ac;
{
    XtAppAddActions( ac, confirm_actions, XtNumber(confirm_actions));
}

Boolean XbConfirm(parent, prompt, destry)
     Widget parent;
     char *prompt;
     Boolean destry;
{  
    Boolean ret = FALSE;
    Widget dialogShell, dialogBox;
    
    Arg warg[4];
    int n = 0;
    
    XEvent event;
    
    confirmState = CONFIRM_WAIT;
    dialogShell = XtCreatePopupShell("confirm_shell", 
				     overrideShellWidgetClass,
				     parent, warg, n); n = 0;
    
    XtSetArg(warg[n], XtNlabel, prompt);n++;
    XtSetArg(warg[n], XtNborderWidth, 5);n++;

    dialogBox = XtCreateManagedWidget( "confirm_dialog", dialogWidgetClass,
				      dialogShell, warg, n); n = 0;

    XawDialogAddButton( dialogBox, "OK", confirmYes, NULL );
    XawDialogAddButton( dialogBox, "Cancel", confirmNo, NULL );
    
    XtRealizeWidget(dialogShell);
    PositionPopupShell(dialogShell,(XEvent*)NULL,dialogShell);
    XtPopup( dialogShell, XtGrabExclusive );
    XtSetKeyboardFocus(dialogShell, dialogBox);

    while(confirmState == CONFIRM_WAIT)
    {
	XtAppNextEvent(app_context, &event);
	XtDispatchEvent( &event );
    }
    
    
    if (destry == TRUE)
	XtDestroyWidget( dialogShell );
    else
	XtPopdown( dialogShell );
    
    if( confirmState == CONFIRM_YES )
	ret = TRUE;

    confirmState = CONFIRM_WAIT;
    return ( ret );
}

void XbWarning(parent, prompt)
     Widget parent;
     char *prompt;
{  
    Widget dialogShell, dialogBox;
    char *temp = NULL;

    Arg warg[4];
    int n = 0;
    
    XEvent event;
    
    confirmState = CONFIRM_WAIT;
    dialogShell = XtCreatePopupShell("confirm_shell", 
				     overrideShellWidgetClass,
				     parent, warg, n); n = 0;

    temp = cpystr(prompt);

    XtSetArg(warg[n], XtNlabel, temp);n++;
    XtSetArg(warg[n], XtNborderWidth, 5);n++;

    dialogBox = XtCreateManagedWidget( "confirm_dialog", dialogWidgetClass,
				      dialogShell, warg, n); n = 0;

    XawDialogAddButton( dialogBox, "OK", confirmYes, NULL );
    
    XtRealizeWidget(dialogShell);
    PositionPopupShell(dialogShell,NULL,dialogShell);
    XtPopup( dialogShell, XtGrabExclusive );
    XBell(XtDisplay(parent), 100);
    XtSetKeyboardFocus(dialogShell, dialogBox);

    while(confirmState == CONFIRM_WAIT)
    {
	XtAppNextEvent(app_context, &event);
	XtDispatchEvent( &event );
    }
    
    XtDestroyWidget( dialogShell );
    confirmState = CONFIRM_WAIT;
}

static void confirmYes(w, s, e)
     Widget w;
     void *s;
     XEvent *e;
{
    confirmState = CONFIRM_YES;
}

static void confirmNo(w, s, e)
     Widget w;
     void *s;
     XEvent *e;
{
    confirmState = CONFIRM_NO;
}

static void confirmYesAct( w, e )
     Widget w;
     XEvent *e;
{
    confirmState = CONFIRM_YES;
}

static void confirmNoAct( w, e )
     Widget w;
     XEvent *e;
{
    confirmState = CONFIRM_NO;
}



