/* -*- C -*-
 *
 * Program:	ximap
 * File:        mailcap.h -- Declarations defs and structures for
 *                           parsing mailcap files (for MIME...)
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_mailcap_h
#define __ximap_mailcap_h
/*
 *  Make sure that the numbers assigned to the types here
 *  match the corresponding numbers in the mail program. (see Client/mail.h )
 *  
 */
#ifndef TYPETEXT

#define TYPETEXT        0		/* unformatted text */
#define TYPEMULTIPART   1		/* multiple part */
#define TYPEMESSAGE     2       	/* encapsulated message */
#define TYPEAPPLICATION 3	        /* external data */
#define TYPEAUDIO       4		/* audio */
#define TYPEIMAGE       5		/* static image */
#define TYPEVIDEO       6		/* video */
#define TYPEOTHER       7		/* other types */

#endif /* TYPETEXT */

#define WILDSUBTYPE     -1

#define NUMBEROFTYPES   8
#define MAILCAPBFRSIZE  1024
#define MAILCAPTOKSIZE  50

#define MIMEtspecials "()<>@,;:\\\"/[]?.="
#define MTEXTspecials "=;\\/"

#define X_TOKENPREFIX "X-"

#define CONTINUELINE '\\'

typedef struct _mediahandler
{
    int       contentType;
    char     * asciiType;
    char     *subType;

    char     *view;
    char     *compose;
    char     *print;

    int       needsterminal;
    int       copiousoutput;

    struct _mediahandler *next;

} Handler, *HandlerPtr, **HandlerArray;

/* 
 *  This can be overridden by the user's MAILCAPPATH environment variable.
 *
 */

#define MAILCAPPATH   "$HOME/.mailcap:/etc/mailcap:/usr/etc/mailcap:/usr/local/etc/mailcap"

HandlerArray parseMailcap( );
extern char *firstfound();

#endif /* __ximap_mailcap_h */



