/* -*- C -*-
 *
 * Program:	ximap
 * File:        buttons.h -- Declarations and structures involved with 
 *                           making buttons and menus.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_buttons_h
#define __ximap_buttons_h

typedef struct _ButtonStruct
{
    char                 *name;
    void                 *function;
    struct _ButtonStruct *menu;
    unsigned int         state;
} ButtonStruct, *ButtonStructPtr;

typedef struct _StateList
{
    Widget            button;
    unsigned int      states;  /* This is the OR of the states when button is *in*sensitive */
    struct _StateList *next;
} StateList, *StateListPtr;

extern StateList* createButtons();
extern StateList* makeStateList();
extern void checkButtonStates();
extern void free_statelist();

extern Widget buttonFromStateList();
extern Widget makeMenu();

#define INFO_EVENTS ((EventMask) EnterWindowMask | LeaveWindowMask)

/* This state means a button will never be insensitive -- it's always hot. */
#define NEVER          ((unsigned int) 0)

#endif /* __ximap_buttons_h */

