/***********************************************************
*
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*                   brock@sumex-aim.stanford.edu
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/

/*
 * CascadeMenuP.h - Private Header file for SimpleMenu widget.
 *
 * Date:    December 5, 1990
 *
 */

#ifndef _CascadeMenuP_h
#define _CascadeMenuP_h

#include "CascadeMenu.h"
#include "SmeCasc.h"
#include <X11/Xaw/SimpleMenP.h>
#include <X11/Xaw/SmeP.h>
#include <X11/ShellP.h>

#define ForAllChildren(smw, childP) \
  for ( (childP) = (SmeObject *) (smw)->composite.children ; \
        (childP) < (SmeObject *) ( (smw)->composite.children + \
				 (smw)->composite.num_children ) ; \
        (childP)++ )

typedef struct {
    int empty;		/* For future needs. */
} CascadeMenuClassPart;

typedef struct _CascadeMenuClassRec {
  CoreClassPart	          core_class;
  CompositeClassPart      composite_class;
  ShellClassPart          shell_class;
  OverrideShellClassPart  override_shell_class;
  SimpleMenuClassPart	  simpleMenu_class;
  CascadeMenuClassPart    cascadeMenu_class;
} CascadeMenuClassRec;

extern CascadeMenuClassRec cascadeMenuClassRec;

/* just the same resources as simpleMenu */
typedef struct _CascadeMenuPart {
  /* resources */
  
  /* private state */
  SmeCascObject              popped_up;
} CascadeMenuPart;

typedef struct _CascadeMenuRec {
  CorePart		core;
  CompositePart 	composite;
  ShellPart 	        shell;
  OverrideShellPart     override;
  SimpleMenuPart	simple_menu;
  CascadeMenuPart       cascade_menu;
} CascadeMenuRec;

#endif /* _CascadeMenuP_h */
