/***********************************************************
*
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*                   brock@sumex-aim.stanford.edu
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/
#include <stdio.h>
#include <string.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/XawInit.h>
#include "CascadeMenuP.h"
#include "SmeCascP.h"
#include <X11/Xaw/Cardinals.h>

#include <X11/Xmu/Initer.h>
#include <X11/Xmu/CharSet.h>

static void CheckCascade();
static void Notify();

static char defaultTranslations[] =
    "<EnterWindow>:     highlight()                       \n\
     <LeaveWindow>:     unhighlight()                     \n\
     <BtnMotion>:       highlight() check_cascade()       \n\
     <BtnUp>:           MenuPopdown() notify() unhighlight()"; 

static XtActionsRec actionsList[] =
{
  {"check_cascade",  CheckCascade},
  {"notify",         Notify      },
};

static void Initialize();
static void ClassInitialize();
static Boolean SetValues();

static void PopdownChildren();
 
#define superclass (&simpleMenuClassRec)
    
CascadeMenuClassRec cascadeMenuClassRec = {
  {
    /* superclass         */    (WidgetClass) superclass,
    /* class_name         */    "CascadeMenu",
    /* size               */    sizeof(CascadeMenuRec),
    /* class_initialize   */	ClassInitialize,
    /* class_part_initialize*/	NULL,
    /* Class init'ed      */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    actionsList,
    /* num_actions        */    XtNumber(actionsList),
    /* resources          */    NULL,
    /* resource_count     */	0,
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE, 
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/ 	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    SetValues,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */	XtInheritSetValuesAlmost,  
    /* get_values_hook    */	NULL,			
    /* accept_focus       */    NULL,
    /* intrinsics version */	XtVersion,
    /* callback offsets   */    NULL,
    /* tm_table		  */    defaultTranslations,
    /* query_geometry	  */    NULL,
    /* display_accelerator*/    NULL,
    /* extension	  */    NULL
  },{
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension	  */    NULL
  },{
    /* Shell extension	  */    NULL
  },{
    /* Override extension */    NULL
  },{
    /* Simple Menu extension*/  NULL
  }
};

WidgetClass cascadeMenuWidgetClass = (WidgetClass)&cascadeMenuClassRec;

/************************************************************
 *
 * Semi-Public Functions.
 *
 ************************************************************/

/*      Function Name: ClassInitialize
 *      Description: Class Initialize routine, called only once.
 *      Arguments: none.
 *      Returns: none.
 */

static void
ClassInitialize()
{
  XawInitializeWidgetSet();
  XtAddConverter( XtRString, XtRBackingStore, XmuCvtStringToBackingStore,
		 NULL, 0 );
}

/*      Function Name: Initialize
 *      Description: Initializes the simple menu widget
 *      Arguments: request - the widget requested by the argument list.
 *                 new     - the new widget with both resource and non
 *                           resource values.
 *      Returns: none.
 */

/* ARGSUSED */
static void
Initialize(request, new)
Widget request, new;
{
  CascadeMenuWidget cmw = (CascadeMenuWidget) new;

  cmw->cascade_menu.popped_up = NULL;

  XtAddCallback( cmw, XtNpopdownCallback, PopdownChildren, new );
}


/* ARGSUSED */
static Boolean
SetValues(current, request, new)
Widget current, request, new;
{
    return(TRUE);
}



/* ARGSUSED */
static void
CheckCascade(w, event, params, num_params)
Widget w;
XEvent * event;
String * params;
Cardinal * num_params;
{ 
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;
  SmeObject entry = cmw->simple_menu.entry_set;
  SmeCascObject casc = (SmeCascObject) cmw->simple_menu.entry_set;
  SmeObjectClass class;
  
  
  if ( entry == NULL) return;
  
  class = (SmeObjectClass) entry->object.widget_class;
  
  if (XtIsSubclass( entry, smeCascObjectClass ))
    {
      if (cmw->cascade_menu.popped_up == casc
	  && event->xcrossing.x >= (4*entry->rectangle.width/5))
	return;

      if (cmw->cascade_menu.popped_up != NULL)
	{
	  (class->sme_class.notify)((Widget) cmw->cascade_menu.popped_up);
	  cmw->cascade_menu.popped_up = NULL;
	}

      if(event->xcrossing.x >= (4*entry->rectangle.width/5))
	{
	  cmw->cascade_menu.popped_up = casc;
	  Notify( w, event, params, num_params );
	}    
    }
}


/* ARGSUSED */
static void
Notify(w, event, params, num_params)
Widget w;
XEvent * event;
String * params;
Cardinal * num_params;
{
    CascadeMenuWidget cmw = (CascadeMenuWidget) w;
    SmeObject entry = cmw->simple_menu.entry_set;
    SmeObjectClass class;
    
    if ( (entry == NULL) || !XtIsSensitive((Widget) entry) ) return;

    class = (SmeObjectClass) entry->object.widget_class;
    (class->sme_class.notify)( (Widget) entry );
}

static void
PopdownChildren( w )
     Widget w;
{
  CascadeMenuWidget cmw = (CascadeMenuWidget) w;
  SmeCascObject casc = (SmeCascObject) cmw->cascade_menu.popped_up;
  SmeObjectClass class;
  
  if ( casc == NULL) return;
  
  class = (SmeObjectClass) casc->object.widget_class;
  
  if (XtIsSubclass( casc, smeCascObjectClass ))
    {
      (class->sme_class.notify)((Widget) casc);
    }
  
  cmw->cascade_menu.popped_up = NULL;
}  
