/* -*- C -*-
 *
 * Program:	ximap
 * File:        util.h -- Whatever didn't end up somewhere else :-)
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_util_h
#define __ximap_util_h

/* max host name length in getQualifiedHostname() */
#define HNAMELEN 256

/* This is used when we need to read an arbitrary file into memory... */
typedef struct binary_buffer
{
    long     bufferSize;
    char    *bufferContents;
} BinaryBuffer;

extern BinaryBuffer* readFileToMem(/* FILE* */);
XbListSelection* makeMultiPartHeaderList( /* PART* */);

extern Widget getShell();
extern char* shortheader();
extern char* updateSequence();

extern void doReply();
extern void doRemail();
extern void doComposeNew();
extern void doForward();
extern void doCopy();
extern void doMove();
extern void doPrint();
extern void doSetFlag();
extern void doClearFlag();

extern void addComposeWindowToMailbox();
extern void inputString();
extern void PositionPopupShell();
extern char *resolvepath();
extern FILE* displayMultiMedia();
extern Handler *getHandler();
void parseMailboxName();

#endif /*  __ximap_util_h */
