/*
 * Decompiled with CFR 0.152.
 */
package patpack.stack;

import java.awt.Graphics;
import patpack.card.Card;
import patpack.stack.CardDrag;
import patpack.stack.CardStack;

public class ClockPile
extends CardStack {
    public int select(int sx, int sy) {
        int dx = sx - this.x;
        int dy = sy - this.y;
        int size = this.stack.size();
        if (size <= 0) {
            return -1;
        }
        if (dx < 0 || dx >= 77) {
            return -1;
        }
        if (dy < 0 || dy >= 102) {
            return -1;
        }
        return 0;
    }

    public CardStack take(int cardPos) {
        return null;
    }

    public boolean turn(int cardPos) {
        return false;
    }

    public boolean drop(int cardPos, CardDrag drag, boolean cheat) {
        if (!this.dropOkay(cardPos, drag) && !cheat) {
            return false;
        }
        this.add(0, drag.getDrag());
        CardStack deck = (CardStack)this.game.getCardStacks().get(0);
        if (!deck.isDeck()) {
            return true;
        }
        Card c = this.removeCard(this.getSize() - 1);
        --this.numFaceDown;
        deck.add(deck.getSize() - deck.numFaceDown(), c);
        drag.setCanUndo(false);
        return true;
    }

    protected boolean dropOkay(int cardPos, CardDrag drag) {
        CardStack s = drag.getSrc();
        if (s.getX() == this.x && s.getY() == this.y) {
            return false;
        }
        s = drag.getDrag();
        Card c = s.getCard(0);
        return CardDrag.dropEmptyMatch(this, c);
    }

    public void draw(Graphics g) {
        int size = this.stack.size();
        if (size <= 0) {
            this.cardBase.draw(g, this.x, this.y);
            return;
        }
        int x = this.x;
        int y = this.y;
        int i = 0;
        while (i < size) {
            this.getCard(i).draw(g, x, y, i >= size - this.numFaceDown);
            x += 2;
            y += 2;
            ++i;
        }
    }
}

