/*
 * Decompiled with CFR 0.152.
 */
package patpack.stack;

import java.awt.Graphics;
import patpack.card.Card;
import patpack.stack.CardDrag;
import patpack.stack.CardStack;

public class AccordPile
extends CardStack {
    public int select(int sx, int sy) {
        int size = this.stack.size();
        if (size <= 0) {
            return -1;
        }
        int dx = sx - this.x;
        int dy = sy - this.y;
        if (dx < 0 || dx >= 71) {
            return -1;
        }
        if (dy < 0 || dy >= 96) {
            return -1;
        }
        return size - 1;
    }

    public CardStack take(int cardPos) {
        if (cardPos < 0 || this.prevStack == null) {
            return null;
        }
        int size = this.stack.size();
        if (size <= 0) {
            return null;
        }
        AccordPile newStack = new AccordPile();
        newStack.init(this.game, this.x, this.y, ' ');
        int i = 0;
        while (i < size) {
            newStack.add(this.getCard(0));
            this.stack.remove(0);
            ++i;
        }
        return newStack;
    }

    public boolean turn(int cardPos) {
        return false;
    }

    public boolean drop(int cardPos, CardDrag drag, boolean cheat) {
        if (!this.dropOkay(cardPos, drag) && !cheat) {
            return false;
        }
        this.add(cardPos + 1, drag.getDrag());
        return true;
    }

    protected boolean dropOkay(int cardPos, CardDrag drag) {
        CardStack s = drag.getSrc();
        int sx = s.getX();
        int sy = s.getY();
        int dist = 0;
        while (s.getX() != this.x || s.getY() != this.y) {
            if ((s = s.getPrevStack()) == null) {
                return false;
            }
            if (s.getX() == sx && s.getY() == sy) continue;
            ++dist;
            sx = s.getX();
            sy = s.getY();
        }
        if (dist != 1 && dist != 3) {
            return false;
        }
        s = drag.getDrag();
        Card c1 = s.getCard(s.getSize() - 1);
        Card c2 = this.getCard(this.getSize() - 1);
        return c1.getSuit() == c2.getSuit() || c1.getValue() == c2.getValue();
    }

    public void draw(Graphics g) {
        int size = this.stack.size();
        if (size <= 0) {
            return;
        }
        this.getCard(size - 1).draw(g, this.x, this.y, false);
    }
}

