/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import patpack.dice.Dice;
import patpack.game.DiceGame;
import patpack.scores.SquLineScores;

public class SquareLines
extends DiceGame {
    private SquLineScores scores = null;
    private int numDeals = 0;

    protected void initScores() {
        this.scores = new SquLineScores();
        this.patpack.getScores().init(this.scores);
    }

    public void start() {
        super.start();
        Dice roll = new Dice(this, 140, 48, false);
        roll.setStyle('r');
        roll.setValue(1);
        this.diceArray.add(roll);
        this.numDeals = 0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int x = 100 + 88 * j;
                int y = 160 + 88 * i;
                Dice dice = new Dice(this, x, y, true);
                this.diceArray.add(dice);
                ++j;
            }
            ++i;
        }
        this.scores.resetScores();
    }

    public boolean diceMark(int numDice) {
        if (numDice == 0) {
            this.diceRoll();
            return true;
        }
        Dice dice = (Dice)this.diceArray.get(numDice);
        if (dice.getValue() <= 0 || dice.getColor() != 'r') {
            dice.setColor('r');
        } else {
            dice.setColor('b');
        }
        return true;
    }

    public void diceRoll() {
        boolean hasDealt = false;
        int i = 1;
        while (i <= 9) {
            Dice dice = (Dice)this.diceArray.get(i);
            if (dice.getColor() == 'r') {
                dice.setValue(this.getRandom(9) + 1);
                hasDealt = true;
            }
            ++i;
        }
        this.scores.calc(this.diceArray);
        if (hasDealt && ++this.numDeals >= 5) {
            Dice roll = (Dice)this.diceArray.get(0);
            roll.setValue(0);
        }
        this.updateStatus();
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        int total = this.scores.getTotal();
        if (total >= 50) {
            this.setFinished();
        }
        if (this.numDeals >= 5) {
            this.setFailed("You failed to get 50 or more points");
        }
    }
}

