/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import patpack.card.Card;
import patpack.game.CardGame;
import patpack.stack.CardDeck;
import patpack.stack.CardPile;
import patpack.stack.CardStack;

public class Families
extends CardGame {
    private Timer matchTimer = null;

    public void start() {
        super.start();
        CardDeck deck = new CardDeck();
        deck.init(this, 0, 0, ' ');
        deck.initDeck(4, 0, 0);
        int j = 0;
        while (j < 4) {
            int i = 0;
            while (i < 8) {
                CardPile pile = new CardPile();
                int x = 24 + 87 * i;
                int y = 24 + 112 * j;
                pile.init(this, x, y, 'g');
                pile.setAutoDrop(true);
                deck.deal(1, pile);
                pile.setFaceDown(1);
                this.cardStacks.add(pile);
                ++i;
            }
            ++j;
        }
    }

    public boolean stackMark(CardStack stack) {
        if (stack.numFaceDown() < stack.getSize()) {
            return true;
        }
        int num = 0;
        int i = this.cardStacks.size() - 1;
        while (i >= 0) {
            CardStack s = (CardStack)this.cardStacks.get(i);
            if (s.numFaceDown() < s.getSize()) {
                ++num;
            }
            --i;
        }
        if (num < 3) {
            stack.setFaceDown(0);
        }
        if (num >= 2) {
            DelayedMatch match = new DelayedMatch(this);
            this.matchTimer = new Timer(500, match);
            this.matchTimer.setRepeats(false);
            this.matchTimer.start();
        }
        return true;
    }

    private void checkMatch() {
        int total = 0;
        int redJokers = 0;
        int blackJokers = 0;
        int jackSuit = 106;
        int queenSuit = 106;
        int kingSuit = 106;
        int i = this.cardStacks.size() - 1;
        while (i >= 0) {
            CardStack s = (CardStack)this.cardStacks.get(i);
            if (s.getSize() > 0) {
                ++total;
                if (s.numFaceDown() <= 0) {
                    Card c = s.getCard(0);
                    char suit = c.getSuit();
                    int val = c.getValue();
                    if (suit == 'j' && val == 2) {
                        ++redJokers;
                    }
                    if (suit == 'j' && val == 1) {
                        ++blackJokers;
                        s.setMark('x');
                        this.table.repaint();
                    }
                    if (suit != 'j' && val == 11) {
                        jackSuit = suit;
                    }
                    if (suit != 'j' && val == 12) {
                        queenSuit = suit;
                    }
                    if (suit != 'j' && val == 13) {
                        kingSuit = suit;
                    }
                }
            }
            --i;
        }
        if (blackJokers >= 2) {
            this.setFailed("You failed with two or more black jokers");
            return;
        }
        if (redJokers > 0) {
            this.shuffleStacks();
            this.clearMatch(false, false);
            return;
        }
        if (jackSuit == 106 || queenSuit != jackSuit || kingSuit != jackSuit) {
            this.clearMatch(false, false);
            return;
        }
        this.clearMatch(true, false);
        if ((total -= 3) <= 8) {
            this.clearMatch(true, true);
            this.setFinished();
        }
    }

    private void clearMatch(boolean remove, boolean show) {
        int i = this.cardStacks.size() - 1;
        while (i >= 0) {
            CardStack s = (CardStack)this.cardStacks.get(i);
            s.setMark(' ');
            if (s.numFaceDown() == s.getSize()) {
                if (show) {
                    s.setFaceDown(0);
                }
            } else {
                if (remove) {
                    s.removeCard(0);
                }
                s.setFaceDown(s.getSize());
            }
            --i;
        }
        this.table.repaint();
    }

    private void shuffleStacks() {
        int i = this.cardStacks.size() - 1;
        while (i >= 0) {
            CardStack s2;
            CardStack s1 = (CardStack)this.cardStacks.get(i);
            if (s1.numFaceDown() >= s1.getSize() && (s2 = (CardStack)this.cardStacks.get(this.getRandom(32))).numFaceDown() >= s2.getSize()) {
                int x1 = s1.getX();
                int y1 = s1.getY();
                int x2 = s2.getX();
                int y2 = s2.getY();
                s1.move(x2, y2);
                s2.move(x1, y1);
            }
            --i;
        }
        this.table.repaint();
    }

    class DelayedMatch
    implements ActionListener {
        private Families game = null;

        public DelayedMatch(Families game) {
            this.game = game;
        }

        public void actionPerformed(ActionEvent evt) {
            this.game.matchTimer.stop();
            this.game.matchTimer = null;
            this.game.checkMatch();
        }
    }
}

