/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import java.awt.Graphics;
import java.util.ArrayList;
import patpack.card.CardBack;
import patpack.game.Game;
import patpack.stack.CardDrag;
import patpack.stack.CardStack;

public class CardGame
extends Game {
    protected ArrayList cardStacks = null;
    protected CardBack cardBack = null;
    protected CardDrag drag = null;
    protected int dragX = 0;
    protected int dragY = 0;
    protected CardDrag undoDrag = null;

    public void start() {
        super.start();
        this.cardStacks = new ArrayList();
        if (this.cardBack == null) {
            this.setCardBack(1);
        }
        this.drag = null;
        this.undoDrag = null;
    }

    public void destroy() {
        this.cardStacks = null;
        this.cardBack = null;
        this.drag = null;
        this.undoDrag = null;
        super.destroy();
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        int i = 0;
        while (i < this.cardStacks.size()) {
            CardStack stack = (CardStack)this.cardStacks.get(i);
            if (!stack.isFinished()) {
                return;
            }
            ++i;
        }
        this.setFinished();
    }

    public void setCardBack(int backNum) {
        this.cardBack = new CardBack(this, backNum);
        this.table.repaint();
    }

    public CardBack getCardBack() {
        return this.cardBack;
    }

    public ArrayList getCardStacks() {
        return this.cardStacks;
    }

    public boolean mousePress(int x, int y) {
        return this.cardSelect(x, y, false);
    }

    public boolean mouseRelease(int x, int y) {
        boolean updated = this.cardDrop(x, y);
        this.updateStatus();
        return updated;
    }

    public boolean mouseClick(int x, int y) {
        return false;
    }

    public boolean mouseDblClick(int x, int y) {
        boolean updated = this.cardAutoDrag(x, y);
        this.updateStatus();
        return updated;
    }

    public boolean mouseDrag(int x, int y) {
        return this.cardDrag(x, y);
    }

    protected boolean cardSelect(int x, int y, boolean autoDrag) {
        if (this.isFinished() || this.isFailed()) {
            return false;
        }
        this.drag = null;
        CardStack dragSrc = null;
        int dragSrcIdx = 0;
        int i = this.cardStacks.size() - 1;
        while (i >= 0 && dragSrc == null) {
            CardStack stack = (CardStack)this.cardStacks.get(i);
            dragSrcIdx = stack.select(x, y);
            if (dragSrcIdx >= 0 || dragSrcIdx == -3) {
                dragSrc = stack;
            }
            --i;
        }
        if (dragSrc == null) {
            return false;
        }
        CardStack dragStack = dragSrc.take(dragSrcIdx);
        if (dragStack != null) {
            this.drag = new CardDrag(dragSrc, dragSrcIdx, dragStack);
            this.dragX = dragStack.getX() - x;
            this.dragY = dragStack.getY() - y;
            return true;
        }
        if (autoDrag) {
            return false;
        }
        if (!dragSrc.isDeck() && this.stackMark(dragSrc)) {
            this.enableUndo(false);
            this.undoDrag = null;
            return true;
        }
        if (dragSrc.turn(dragSrcIdx)) {
            int i2 = this.cardStacks.size() - 1;
            while (i2 >= 0) {
                CardStack s = (CardStack)this.cardStacks.get(i2);
                if (s.isMarked()) {
                    s.setMark(' ');
                }
                --i2;
            }
            this.updateStatus();
            this.enableUndo(false);
            this.undoDrag = null;
            return true;
        }
        return false;
    }

    protected boolean cardDrag(int x, int y) {
        if (this.drag == null) {
            return false;
        }
        this.drag.getDrag().move(x + this.dragX, y + this.dragY);
        return true;
    }

    protected boolean cardDrop(int x, int y) {
        if (this.drag == null) {
            return false;
        }
        int cx = x + this.dragX + 35;
        int cy = y + this.dragY + 48 - 16;
        CardStack dragDest = null;
        int dragDestIdx = 0;
        int i = 0;
        while (i < this.cardStacks.size() && dragDest == null) {
            CardStack stack = (CardStack)this.cardStacks.get(i);
            dragDestIdx = stack.select(cx, cy);
            if (dragDestIdx >= 0 || dragDestIdx == -2) {
                dragDest = stack;
            }
            ++i;
        }
        if (dragDest != null && dragDest.drop(dragDestIdx, this.drag, this.cheat)) {
            this.drag.setDest(dragDest, dragDestIdx);
            this.undoDrag = this.drag;
            this.enableUndo(this.drag.canUndo());
            this.drag = null;
            return true;
        }
        this.drag.getSrc().add(this.drag.getSrcIdx(), this.drag.getDrag());
        this.drag = null;
        return true;
    }

    protected boolean cardAutoDrag(int x, int y) {
        if (!this.cardSelect(x, y, true) || this.drag == null) {
            return false;
        }
        int i = 0;
        while (i < this.cardStacks.size()) {
            CardStack dragDest = (CardStack)this.cardStacks.get(i);
            if (dragDest.autoDrop()) {
                int dragDestIdx = dragDest.getSize() - 1;
                if (dragDestIdx < 0) {
                    dragDestIdx = -2;
                }
                if (dragDest.drop(dragDestIdx, this.drag, false)) {
                    this.drag.setDest(dragDest, dragDestIdx);
                    this.undoDrag = this.drag;
                    this.enableUndo(this.drag.canUndo());
                    this.drag = null;
                    return true;
                }
            }
            ++i;
        }
        this.drag.getSrc().add(this.drag.getSrcIdx(), this.drag.getDrag());
        this.drag = null;
        return true;
    }

    protected boolean stackMark(CardStack stack) {
        return false;
    }

    protected void removeMarked() {
        int i = this.cardStacks.size() - 1;
        while (i >= 0) {
            CardStack s = (CardStack)this.cardStacks.get(i);
            if (s.isMarked()) {
                s.setMark(' ');
                if (s.getSize() > 0) {
                    s.removeCard(s.getSize() - 1);
                }
            }
            --i;
        }
        this.updateStatus();
    }

    public void undo() {
        this.enableUndo(false);
        if (this.undoDrag != null) {
            this.undoDrag.undo();
        }
        this.undoDrag = null;
        this.updateStatus();
        this.table.repaint();
    }

    public void draw(Graphics g) {
        super.draw(g);
        int i = 0;
        while (i < this.cardStacks.size()) {
            CardStack stack = (CardStack)this.cardStacks.get(i);
            stack.draw(g);
            ++i;
        }
        if (this.drag != null) {
            this.drag.getDrag().draw(g);
        }
    }
}

