/*
 * Decompiled with CFR 0.152.
 */
package patpack.dice;

import java.awt.Graphics;
import javax.swing.ImageIcon;
import patpack.game.Game;

public class Dice {
    public static final int DICEWIDTH = 64;
    public static final int DICEHEIGHT = 64;
    public static final char RED = 'r';
    public static final char BLUE = 'b';
    public static final char GRAY = 'g';
    public static final char DOTS = 'd';
    public static final char DIGIT = 'n';
    public static final char ROLL = 'r';
    public static final char LADYBIRD = 'l';
    protected Game game = null;
    protected int x;
    protected int y;
    protected boolean base = false;
    protected ImageIcon baseIcon = null;
    protected char color = (char)114;
    protected ImageIcon diceIcon = null;
    protected char style = (char)100;
    protected int value = 0;
    protected ImageIcon faceIcon = null;

    public Dice(Game game, int x, int y, boolean base) {
        this.game = game;
        this.x = x;
        this.y = y;
        this.base = base;
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean select(int x, int y) {
        if (x < this.x || x >= this.x + 64) {
            return false;
        }
        if (y < this.y || y >= this.y + 64) {
            return false;
        }
        return this.value > 0;
    }

    public void setStyle(char style) {
        this.style = style;
        if (style != 'd') {
            this.setColor('g');
        }
    }

    public void setColor(char color) {
        this.color = color;
        this.diceIcon = null;
    }

    public char getColor() {
        return this.color;
    }

    public void setValue(int value) {
        this.value = value;
        this.faceIcon = null;
    }

    public int getValue() {
        return this.value;
    }

    protected void drawBase(Graphics g) {
        if (!this.base) {
            return;
        }
        this.baseIcon = this.game.loadIcon("dice/x/d.gif");
        this.baseIcon.paintIcon(this.game.getTable(), g, this.x, this.y);
    }

    protected void drawDice(Graphics g) {
        if (this.diceIcon == null) {
            this.diceIcon = this.game.loadIcon("dice/x/" + this.color + ".gif");
        }
        this.diceIcon.paintIcon(this.game.getTable(), g, this.x, this.y);
    }

    protected void drawFace(Graphics g) {
        if (this.faceIcon == null) {
            this.faceIcon = this.game.loadIcon("dice/" + this.style + "/" + this.value + ".gif");
        }
        this.faceIcon.paintIcon(this.game.getTable(), g, this.x, this.y);
    }

    public void draw(Graphics g) {
        if (this.value <= 0) {
            this.drawBase(g);
            return;
        }
        this.drawDice(g);
        this.drawFace(g);
    }
}

