/*
 * Decompiled with CFR 0.152.
 */
package patpack.applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import patpack.applet.PatPack;
import patpack.scores.SingleScore;

public class Scores
implements ListSelectionListener {
    private PatPack patpack = null;
    private JPanel scoreArea = null;
    private JTable scoreTable = null;
    private boolean visible = false;

    public Scores(PatPack patpack) {
        this.patpack = patpack;
        this.scoreTable = new JTable();
        int height = this.scoreTable.getRowHeight() * 5 / 4;
        this.scoreTable.setRowHeight(height);
        this.scoreTable.setSelectionMode(0);
        ListSelectionModel rowSM = this.scoreTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
        Renderer renderer = new Renderer();
        this.scoreTable.setDefaultRenderer(new String().getClass(), renderer);
        this.scoreTable.setDefaultRenderer(new SingleScore().getClass(), renderer);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(new EtchedBorder());
        tablePanel.add((Component)this.scoreTable.getTableHeader(), "North");
        tablePanel.add(this.scoreTable);
        this.scoreArea = new JPanel(new BorderLayout());
        this.scoreArea.add((Component)tablePanel, "North");
    }

    public void setColor(String tableColor) {
        Color color = Color.decode(tableColor);
        this.scoreArea.setBackground(color);
    }

    public void init(TableModel model) {
        if (model == null) {
            if (this.visible) {
                this.patpack.getPlayArea().remove(this.scoreArea);
            }
            this.visible = false;
            return;
        }
        this.scoreTable.setModel(model);
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn column = this.scoreTable.getColumnModel().getColumn(i);
            int width = i == 0 ? 100 : 70;
            column.setPreferredWidth(width);
            ++i;
        }
        if (!this.visible) {
            this.patpack.getPlayArea().add((Component)this.scoreArea, "West");
        }
        this.visible = true;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel model = (ListSelectionModel)e.getSource();
        if (model.isSelectionEmpty()) {
            return;
        }
        int row = model.getMinSelectionIndex();
        model.clearSelection();
        this.patpack.getGame().selectScore(row);
    }

    class Renderer
    implements TableCellRenderer {
        JLabel textRenderer = new JLabel();
        JButton selRenderer = null;

        public Renderer() {
            this.textRenderer.setHorizontalAlignment(0);
            this.selRenderer = new JButton();
            this.selRenderer.setForeground(Color.red);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof SingleScore && ((SingleScore)value).isTemp()) {
                this.selRenderer.setText(value.toString());
                return this.selRenderer;
            }
            this.textRenderer.setText(value.toString());
            return this.textRenderer;
        }
    }
}

