/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import isteam.koloomnz.KoloomnzMIDlet;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreen
extends Canvas {
    private final KoloomnzMIDlet m_midlet;
    private final Displayable m_next;
    private Image m_image;
    private Timer m_timer = new Timer();

    SplashScreen(KoloomnzMIDlet midlet, Displayable next) {
        this.m_midlet = midlet;
        this.m_next = next;
        try {
            this.m_image = Image.createImage((String)"/splash.png");
        }
        catch (Exception ex) {
            this.m_image = null;
        }
    }

    void start() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
        }
        this.m_timer = new Timer();
        TimerTask dismissTask = new TimerTask(){

            public void run() {
                if (SplashScreen.this.m_timer != null) {
                    SplashScreen.this.dismiss();
                }
            }
        };
        this.m_timer.schedule(dismissTask, 4000L);
    }

    private void dismiss() {
        this.m_timer.cancel();
        this.m_midlet.splashScreenDone(this.m_next);
    }

    public void paint(Graphics g) {
        int imageWidth = 0;
        int imageHeight = 0;
        if (this.m_image != null) {
            imageWidth = this.m_image.getWidth();
            imageHeight = this.m_image.getHeight();
        }
        int canvasWidth = this.getWidth();
        int canvasHeight = this.getHeight();
        Font font = Font.getFont((int)0, (int)1, (int)8);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        int y = canvasHeight - imageHeight;
        if (canvasHeight >= imageHeight + 4 + font.getHeight()) {
            y -= 4 + font.getHeight();
        }
        y /= 2;
        if (this.m_image != null) {
            g.drawImage(this.m_image, canvasWidth / 2, y, 0x10 | 1);
        }
        if (canvasHeight >= (y += imageHeight + 4) + font.getHeight()) {
            g.setFont(font);
            g.setColor(0);
            String vendor = this.m_midlet.getAppProperty("MIDlet-Vendor");
            g.drawString(String.valueOf(vendor), canvasWidth / 2, y, 0x10 | 1);
        }
    }

    public void keyPressed(int keyCode) {
        this.dismiss();
    }
}

