/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import isteam.koloomnz.KolDictionary;
import isteam.koloomnz.KoloomnzMIDlet;
import isteam.koloomnz.Settings;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

class SettingsScreen
extends List
implements CommandListener {
    private final KoloomnzMIDlet midlet;
    private final KolDictionary dict;
    private final Displayable previous;
    private final String soundSetting;
    private final String vibraSetting;

    SettingsScreen(KoloomnzMIDlet midlet, KolDictionary dict, Displayable previous) {
        super(dict.getString(KolDictionary.LABEL_SETTINGS), 3);
        this.midlet = midlet;
        this.dict = dict;
        this.previous = previous;
        this.soundSetting = dict.getString(KolDictionary.LABEL_SOUND);
        String onOff = this.onOffString(Settings.getUseSound());
        this.append(this.soundSetting + " " + onOff, null);
        this.vibraSetting = dict.getString(KolDictionary.LABEL_VIBRATION);
        onOff = this.onOffString(Settings.getUseVibration());
        this.append(this.vibraSetting + " " + onOff, null);
        this.addCommand(new Command(dict.getString(KolDictionary.LABEL_BACK), 2, 1));
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable d) {
        if (command == List.SELECT_COMMAND) {
            switch (this.getSelectedIndex()) {
                case 0: {
                    this.midlet.settingsScreenEdit(this.soundSetting, Settings.getUseSound());
                    break;
                }
                case 1: {
                    this.midlet.settingsScreenEdit(this.vibraSetting, Settings.getUseVibration());
                }
            }
        } else {
            this.midlet.settingsScreenBack(this.previous);
        }
    }

    void setUseSound(boolean isOn) {
        String onOff = this.onOffString(Settings.getUseSound());
        this.set(0, this.soundSetting + " " + onOff, null);
    }

    void setUseVibration(boolean isOn) {
        String onOff = this.onOffString(Settings.getUseVibration());
        this.set(1, this.vibraSetting + " " + onOff, null);
    }

    String onOffString(boolean isOn) {
        return this.dict.getString(isOn ? KolDictionary.LABEL_ON : KolDictionary.LABEL_OFF);
    }
}

