/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import isteam.koloomnz.GameEffects;
import isteam.koloomnz.Sounds;

class NokiaGameEffects
extends GameEffects {
    private final Sounds m_sounds = new Sounds(0);
    private volatile boolean isPaused = true;
    private Sound sound = null;
    private volatile int currentPriority = 0;

    NokiaGameEffects() {
    }

    boolean hasSoundCapability() {
        return true;
    }

    boolean hasVibrationCapability() {
        return true;
    }

    private synchronized void setIsPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    void pause() {
        this.setIsPaused(true);
        if (this.sound != null) {
            this.sound.stop();
        }
        DeviceControl.stopVibra();
    }

    void resume() {
        this.setIsPaused(false);
    }

    private void playSound(int priority, byte[] bytes) {
        block5: {
            if (this.isPaused || !this.hasSoundCapability() || !this.getUseSound()) break block5;
            try {
                if (this.sound == null || this.sound.getState() != 0) {
                    this.sound = new Sound(bytes, 1);
                    this.sound.setGain(128);
                    this.sound.play(1);
                    this.currentPriority = priority;
                } else if (priority > this.currentPriority) {
                    this.sound.stop();
                    this.sound.init(bytes, 1);
                    this.sound.play(1);
                    this.currentPriority = priority;
                }
            }
            catch (Exception e) {
                this.currentPriority = 0;
            }
        }
    }

    void play(int sound) {
        if (sound == Sounds.SOUND_KOLOOMN_DROP) {
            this.playSound(1, this.m_sounds.KOLOOMN_DROP_SOUND_BYTES);
        } else if (sound == Sounds.SOUND_BLOCK_DESTROY) {
            this.playSound(2, this.m_sounds.BLOCK_DESTROY_SOUND_BYTES);
        } else if (sound == Sounds.SOUND_BLOCK_FALL) {
            this.playSound(3, this.m_sounds.BLOCK_FALL_SOUND_BYTES);
        } else if (sound == Sounds.SOUND_GAME_OVER) {
            this.playSound(4, this.m_sounds.GAME_OVER_SOUND_BYTES);
        }
    }

    void vibrate() {
        block2: {
            if (!this.getUseVibration()) break block2;
            try {
                DeviceControl.startVibra((int)50, (long)100L);
            }
            catch (Exception e) {}
        }
    }
}

