/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import isteam.koloomnz.GameEffects;
import isteam.koloomnz.KolDictionary;
import isteam.koloomnz.KoloomnzMIDlet;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class MainMenu
extends List
implements CommandListener {
    private final KoloomnzMIDlet m_midlet;
    private final KolDictionary m_dictionary;
    private boolean m_bHasContinue = false;

    public MainMenu(KoloomnzMIDlet midlet, KolDictionary dictionary, GameEffects gameEffects) {
        super(midlet.getAppProperty("MIDlet-Name"), 3);
        this.m_midlet = midlet;
        this.m_dictionary = dictionary;
        this.append(this.m_dictionary.getString(KolDictionary.LABEL_NEWGAME), null);
        if (gameEffects.hasSoundCapability() || gameEffects.hasVibrationCapability()) {
            this.append(this.m_dictionary.getString(KolDictionary.LABEL_SETTINGS), null);
        }
        this.append(this.m_dictionary.getString(KolDictionary.LABEL_HIGHSCORES), null);
        this.append(this.m_dictionary.getString(KolDictionary.LABEL_INSTRUCTIONS), null);
        this.append(this.m_dictionary.getString(KolDictionary.LABEL_ABOUT), null);
        this.addCommand(new Command("Exit", 7, 1));
        this.setCommandListener(this);
    }

    void addContinue() {
        if (!this.m_bHasContinue) {
            this.insert(0, this.m_dictionary.getString(KolDictionary.LABEL_CONTINUE), null);
            this.m_bHasContinue = true;
        }
    }

    void deleteContinue() {
        if (this.m_bHasContinue) {
            this.delete(0);
            this.m_bHasContinue = false;
        }
    }

    void selectContinue() {
        if (this.m_bHasContinue) {
            this.setSelectedIndex(0, true);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == List.SELECT_COMMAND) {
            String selected = this.getString(this.getSelectedIndex());
            if (selected.equals(this.m_dictionary.getString(KolDictionary.LABEL_CONTINUE))) {
                this.m_midlet.mainMenuContinue();
            } else if (selected.equals(this.m_dictionary.getString(KolDictionary.LABEL_NEWGAME))) {
                this.m_midlet.mainMenuNewGame();
            } else if (selected.equals(this.m_dictionary.getString(KolDictionary.LABEL_SETTINGS))) {
                this.m_midlet.mainMenuSettings();
            } else if (selected.equals(this.m_dictionary.getString(KolDictionary.LABEL_HIGHSCORES))) {
                this.m_midlet.mainMenuHighscores(-1, "");
            } else if (selected.equals(this.m_dictionary.getString(KolDictionary.LABEL_INSTRUCTIONS))) {
                this.m_midlet.mainMenuInstructions();
            } else if (selected.equals(this.m_dictionary.getString(KolDictionary.LABEL_ABOUT))) {
                this.m_midlet.mainMenuAbout();
            }
        } else {
            this.m_midlet.mainMenuExit();
        }
    }
}

