/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import isteam.koloomnz.CloseableCanvas;
import isteam.koloomnz.GameEffects;
import isteam.koloomnz.KolDictionary;
import isteam.koloomnz.KolGame;
import isteam.koloomnz.KolHighscores;
import isteam.koloomnz.MainMenu;
import isteam.koloomnz.NameEditScreen;
import isteam.koloomnz.SettingEditor;
import isteam.koloomnz.Settings;
import isteam.koloomnz.SettingsScreen;
import isteam.koloomnz.SplashScreen;
import isteam.koloomnz.TextScreen;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class KoloomnzMIDlet
extends MIDlet {
    private final KolDictionary m_dictionary = new KolDictionary(System.getProperty("microedition.locale"), System.getProperty("microedition.encoding"));
    private final MainMenu m_mainMenu;
    private final GameEffects m_gameEffects;
    private SettingsScreen m_settingsScreen;
    private KolGame m_game = null;
    private KolHighscores m_highscores = new KolHighscores(this.m_dictionary);

    public KoloomnzMIDlet() {
        this.m_gameEffects = this.makeGameEffects();
        this.m_mainMenu = new MainMenu(this, this.m_dictionary, this.m_gameEffects);
        Canvas canvas = this.makeCloseableCanvas();
        this.m_game = new KolGame(this, this.m_dictionary, this.m_gameEffects, canvas);
        if (this.m_game.loadGame()) {
            this.m_mainMenu.addContinue();
            this.m_mainMenu.selectContinue();
        }
    }

    protected void startApp() {
        Displayable current = Display.getDisplay((MIDlet)this).getCurrent();
        if (current == null) {
            SplashScreen splashScreen = new SplashScreen(this, (Displayable)this.m_mainMenu);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)splashScreen);
            splashScreen.start();
        } else {
            Display.getDisplay((MIDlet)this).setCurrent(current);
            if (this.m_game != null && current == this.m_game.getCanvas()) {
                this.m_game.resume();
            }
        }
    }

    protected void pauseApp() {
        if (this.m_game != null) {
            this.m_game.stop();
        }
    }

    protected void destroyApp(boolean p1) {
        if (this.m_game != null) {
            this.m_game.stop();
        }
    }

    public void splashScreenDone(Displayable next) {
        Display.getDisplay((MIDlet)this).setCurrent(next);
    }

    public void exitRequested() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private GameEffects makeGameEffects() {
        try {
            Class.forName("com.nokia.mid.sound.Sound");
            Class.forName("com.nokia.mid.ui.DeviceControl");
            Class<?> clas = Class.forName("isteam.koloomnz.NokiaGameEffects");
            return (GameEffects)clas.newInstance();
        }
        catch (Exception e) {
            return new GameEffects();
        }
    }

    private Canvas makeCloseableCanvas() {
        try {
            Class.forName("com.nokia.mid.ui.FullCanvas");
            Class<?> clas = Class.forName("isteam.koloomnz.NokiaCloseableCanvas");
            return (Canvas)clas.newInstance();
        }
        catch (Exception e) {
            String closeLabel = this.m_dictionary.getString(KolDictionary.LABEL_BACK);
            return new CloseableCanvas(closeLabel);
        }
    }

    void gameManagerMainMenu(boolean isGameOver) {
        if (isGameOver) {
            this.m_mainMenu.deleteContinue();
            int iScore = this.m_game.getScore();
            if (this.m_highscores.getLastResult().getScore() <= iScore) {
                NameEditScreen screen = new NameEditScreen(this, this.m_dictionary, this.m_highscores);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)screen);
                return;
            }
        } else {
            this.m_mainMenu.selectContinue();
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.m_mainMenu);
    }

    void textScreenClose() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.m_mainMenu);
    }

    void nameEditScreenClose(String name) {
        this.mainMenuHighscores(this.m_game.getScore(), name);
    }

    void mainMenuAbout() {
        String name = this.getAppProperty("MIDlet-Name");
        String version = this.m_dictionary.getString(KolDictionary.LABEL_VERSION) + " " + this.getAppProperty("MIDlet-Version");
        String vendor = this.getAppProperty("MIDlet-Vendor");
        String about = name + "\n" + version + "\n" + vendor;
        String title = this.m_dictionary.getString(KolDictionary.LABEL_ABOUT);
        String back = this.m_dictionary.getString(KolDictionary.LABEL_BACK);
        TextScreen aboutScreen = new TextScreen(this, title, back);
        aboutScreen.append(about);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)aboutScreen);
    }

    void mainMenuExit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    void mainMenuContinue() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.m_game.getCanvas());
        if (this.m_game.isPaused()) {
            this.m_game.resume();
        } else {
            this.m_game.start();
        }
    }

    void mainMenuNewGame() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.m_game.getCanvas());
        this.m_game.newGame(1);
        this.m_game.start();
        this.m_mainMenu.addContinue();
    }

    void mainMenuSettings() {
        if (this.m_settingsScreen == null) {
            this.m_settingsScreen = new SettingsScreen(this, this.m_dictionary, (Displayable)this.m_mainMenu);
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.m_settingsScreen);
    }

    void mainMenuInstructions() {
        TextScreen textScreen = new TextScreen(this, this.m_dictionary.getString(KolDictionary.LABEL_INSTRUCTIONS), this.m_dictionary.getString(KolDictionary.LABEL_BACK));
        textScreen.append(this.m_dictionary.getString(KolDictionary.TEXT_INSTRUCTIONS));
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)textScreen);
    }

    void mainMenuHighscores(int score, String name) {
        TextScreen textScreen = new TextScreen(this, this.m_dictionary.getString(KolDictionary.LABEL_HIGHSCORES), this.m_dictionary.getString(KolDictionary.LABEL_BACK));
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)textScreen);
        int position = -1;
        if (score != -1) {
            position = this.m_highscores.insertResult(score, name);
        }
        textScreen.append(this.m_highscores.getTable(position));
    }

    void settingEditorSave(String name, boolean isOn) {
        if (name.equals(this.m_dictionary.getString(KolDictionary.LABEL_VIBRATION))) {
            Settings.setUseVibration(isOn);
            this.m_settingsScreen.setUseVibration(isOn);
        } else if (name.equals(this.m_dictionary.getString(KolDictionary.LABEL_SOUND))) {
            Settings.setUseSound(isOn);
            this.m_settingsScreen.setUseSound(isOn);
        }
        Alert confirm = new Alert(null, name + " " + this.m_settingsScreen.onOffString(isOn), null, AlertType.INFO);
        confirm.setTimeout(4000);
        Display.getDisplay((MIDlet)this).setCurrent(confirm, (Displayable)this.m_settingsScreen);
    }

    void settingEditorBack() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.m_settingsScreen);
    }

    void settingsScreenBack(Displayable last) {
        this.m_settingsScreen = null;
        if (this.m_game != null && last == this.m_game.getCanvas()) {
            this.m_game.resume();
        }
        Display.getDisplay((MIDlet)this).setCurrent(last);
    }

    void settingsScreenEdit(String name, boolean isOn) {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)new SettingEditor(this, this.m_dictionary, name, isOn));
    }
}

