/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import isteam.koloomnz.KolGame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Koloomn {
    static final int KOL_LENGTH = 3;
    private final KolGame m_game;
    public int left;
    public int top;
    public final byte[] box;

    public Koloomn(KolGame game) {
        this.m_game = game;
        this.box = new byte[3];
        int i = 0;
        while (i < 3) {
            this.box[i] = this.m_game.randomColor();
            ++i;
        }
        this.left = 3;
        this.top = 0;
    }

    public Koloomn(KolGame game, byte[] bytes) throws IOException {
        ByteArrayInputStream byteInput = new ByteArrayInputStream(bytes);
        DataInputStream input = new DataInputStream(byteInput);
        this.m_game = game;
        this.box = new byte[3];
        this.left = input.readInt();
        this.top = input.readInt();
        input.read(bytes, 0, 3);
    }

    public boolean processAction(int gameAction) {
        switch (gameAction) {
            case 1: 
            case 8: {
                this.rotate();
                return true;
            }
            case 6: {
                this.drop();
                return true;
            }
            case 2: {
                if (this.left <= 0 || this.m_game.box[this.left - 1][this.top + 3 - 1] != -1) break;
                --this.left;
                return true;
            }
            case 5: {
                if (this.left >= 6 || this.m_game.box[this.left + 1][this.top + 3 - 1] != -1) break;
                ++this.left;
                return true;
            }
        }
        return false;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteOutput);
        output.writeInt(this.left);
        output.writeInt(this.top);
        output.write(this.box);
        output.flush();
        return byteOutput.toByteArray();
    }

    private void rotate() {
        byte tmp = this.box[0];
        int i = 0;
        while (i < 2) {
            this.box[i] = this.box[i + 1];
            ++i;
        }
        this.box[2] = tmp;
    }

    private void drop() {
        while (!this.checkDropped()) {
            ++this.top;
        }
        this.m_game.dropKoloomn();
    }

    public boolean checkGameOver() {
        return this.m_game.box[this.left][this.top + 3 - 1] != -1;
    }

    public boolean checkDropped() {
        return this.top + 3 == 15 || this.m_game.box[this.left][this.top + 3] != -1;
    }
}

