/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import isteam.koloomnz.CloseableCanvas;
import isteam.koloomnz.KolDictionary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;

public class KolHighscores {
    private final KolDictionary m_dictionary;
    private RecordStore m_store;
    private RecordEnumeration m_enumeration;
    private int m_defaultPlayerId;
    private String m_defaultPlayerName;

    public KolHighscores(KolDictionary dictionary) {
        this.m_dictionary = dictionary;
        try {
            HSRecord defaultPlayer;
            this.m_store = RecordStore.openRecordStore((String)"Koloomnz.Highscores", (boolean)true);
            this.m_enumeration = this.m_store.enumerateRecords((RecordFilter)new HSRecordFilter(true), (RecordComparator)new HSRecordComparator(), false);
            if (this.m_enumeration.hasNextElement()) {
                defaultPlayer = this.getNextRecord();
                this.m_defaultPlayerName = defaultPlayer.getName();
                this.reset();
                this.m_defaultPlayerId = this.m_enumeration.nextRecordId();
            } else {
                this.m_defaultPlayerName = this.m_dictionary.getString(KolDictionary.LABEL_DEFAULT_PLAYER);
                defaultPlayer = new HSRecord(-1, this.m_defaultPlayerName);
                byte[] record = defaultPlayer.getBytes();
                this.m_defaultPlayerId = this.m_store.addRecord(record, 0, record.length);
            }
            this.m_enumeration = this.m_store.enumerateRecords((RecordFilter)new HSRecordFilter(false), (RecordComparator)new HSRecordComparator(), false);
            if (this.m_enumeration.numRecords() == 0) {
                int i = 1;
                while (i <= 10) {
                    HSRecord result = new HSRecord(i * 10, this.m_defaultPlayerName);
                    byte[] record = result.getBytes();
                    this.m_store.addRecord(record, 0, record.length);
                    ++i;
                }
                this.m_enumeration.rebuild();
            }
        }
        catch (Exception ex) {
            this.m_store = null;
            this.m_enumeration = null;
        }
    }

    public String getDefaultPlayerName() {
        return this.m_defaultPlayerName;
    }

    public HSRecord getLastResult() {
        if (this.m_enumeration == null) {
            return new HSRecord();
        }
        if (this.m_enumeration.numRecords() < 10) {
            return new HSRecord();
        }
        this.m_enumeration.reset();
        try {
            byte[] record = this.m_enumeration.previousRecord();
            return new HSRecord(record);
        }
        catch (Exception ex) {
            return new HSRecord();
        }
    }

    public int insertResult(int score, String name) {
        HSRecord result = new HSRecord(score, name);
        return this.insertResult(result);
    }

    public int insertResult(HSRecord result) {
        if (this.m_enumeration == null) {
            return -1;
        }
        this.m_enumeration.reset();
        try {
            int i = this.m_enumeration.numRecords();
            while (i >= 10) {
                int recordId = this.m_enumeration.previousRecordId();
                this.m_store.deleteRecord(recordId);
                --i;
            }
            byte[] record = result.getBytes();
            int recordId = this.m_store.addRecord(record, 0, record.length);
            this.m_enumeration.rebuild();
            this.m_defaultPlayerName = result.getName();
            result.m_score = -1;
            record = result.getBytes();
            this.m_store.setRecord(this.m_defaultPlayerId, record, 0, record.length);
            int pos = 1;
            while (this.m_enumeration.nextRecordId() != recordId) {
                ++pos;
            }
            return pos;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public void reset() {
        if (this.m_enumeration == null) {
            return;
        }
        this.m_enumeration.reset();
    }

    public boolean hasNextRecord() {
        if (this.m_enumeration == null) {
            return false;
        }
        return this.m_enumeration.hasNextElement();
    }

    public HSRecord getNextRecord() {
        if (this.m_enumeration == null) {
            return new HSRecord();
        }
        if (!this.m_enumeration.hasNextElement()) {
            return new HSRecord();
        }
        try {
            byte[] record = this.m_enumeration.nextRecord();
            return new HSRecord(record);
        }
        catch (Exception ex) {
            return new HSRecord();
        }
    }

    public Image getTable(int current) {
        this.reset();
        Font font = Font.getFont((int)64, (int)0, (int)8);
        int iHeight = font.getHeight() * 10;
        int iWidth = new CloseableCanvas("").getWidth() - 10;
        Image img = Image.createImage((int)iWidth, (int)iHeight);
        Graphics g = img.getGraphics();
        g.setFont(font);
        int pos = 1;
        while (this.hasNextRecord()) {
            if (pos != current) {
                g.setColor(0);
            } else {
                g.setColor(0xFF0000);
            }
            HSRecord result = this.getNextRecord();
            String str = String.valueOf(pos);
            str = str + ". " + result.getName();
            g.drawString(str, 0, (pos - 1) * font.getHeight(), 4 | 0x10);
            str = String.valueOf(result.getScore());
            g.drawString(str, iWidth, (pos - 1) * font.getHeight(), 8 | 0x10);
            ++pos;
        }
        return Image.createImage((Image)img);
    }

    public class HSRecord {
        private int m_score;
        private String m_name;

        protected HSRecord(byte[] record) throws IOException {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(record);
            DataInputStream input = new DataInputStream(byteInput);
            this.m_score = input.readInt();
            this.m_name = input.readUTF();
        }

        protected HSRecord(int score, String name) {
            this.m_score = score;
            this.m_name = name;
        }

        protected HSRecord() {
            this.m_score = 0;
            this.m_name = "noname";
        }

        public int getScore() {
            return this.m_score;
        }

        public String getName() {
            return this.m_name;
        }

        public byte[] getBytes() throws IOException {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteOutput);
            output.writeInt(this.m_score);
            output.writeUTF(this.m_name);
            output.flush();
            return byteOutput.toByteArray();
        }
    }

    private class HSRecordFilter
    implements RecordFilter {
        private final boolean m_bFilterDefaultPlayer;

        public HSRecordFilter(boolean filterDefaultPlayer) {
            this.m_bFilterDefaultPlayer = filterDefaultPlayer;
        }

        public boolean matches(byte[] byteArray) {
            try {
                HSRecord record = new HSRecord(byteArray);
                if (this.m_bFilterDefaultPlayer) {
                    return record.getScore() == -1;
                }
                return record.getScore() != -1;
            }
            catch (IOException ex) {
                return false;
            }
        }
    }

    private class HSRecordComparator
    implements RecordComparator {
        private HSRecordComparator() {
        }

        public int compare(byte[] recArray1, byte[] recArray2) {
            try {
                HSRecord record1 = new HSRecord(recArray1);
                HSRecord record2 = new HSRecord(recArray2);
                if (record1.getScore() > record2.getScore()) {
                    return -1;
                }
                if (record1.getScore() < record2.getScore()) {
                    return 1;
                }
                return 0;
            }
            catch (IOException ex) {
                return 0;
            }
        }
    }
}

