/*
 * Decompiled with CFR 0.152.
 */
package isteam.koloomnz;

import isteam.koloomnz.CRect;
import isteam.koloomnz.GameEffects;
import isteam.koloomnz.KolDictionary;
import isteam.koloomnz.KolUtils;
import isteam.koloomnz.Koloomn;
import isteam.koloomnz.KoloomnzMIDlet;
import isteam.koloomnz.SettableDelegate;
import isteam.koloomnz.Settings;
import isteam.koloomnz.Sounds;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class KolGame
implements Runnable {
    private static final boolean DEMO = true;
    static final int MILLIS_PER_TICK = 10;
    static final int SECONDS_PER_LEVEL = 60;
    static final int FIELD_WIDTH = 7;
    static final int FIELD_HEIGHT = 15;
    static final int BACKGROUND_COLOR = 0xBBBBBB;
    static final int PANEL_COLOR = 0xFFFFFF;
    static final int BORDER_COLOR = 0;
    static final int MARGIN_WIDTH = 4;
    static final int[] BOX_COLORS = new int[]{0, 255, 47872, 0xFF0000, 65535, 0xCC00FF, 0xCCCC00};
    private static int ix = 0;
    static final int GAME_STATE_STOPPED = ix++;
    static final int GAME_STATE_ACTIVE = ix++;
    static final int GAME_STATE_PAUSED = ix++;
    static final int GAME_STATE_PROCESSING_SEARCH = ix++;
    static final int GAME_STATE_PROCESSING_DESTROY = ix++;
    static final int GAME_STATE_PROCESSING_DROP = ix++;
    private final KoloomnzMIDlet m_midlet;
    private final KolDictionary m_dictionary;
    private final GameEffects m_gameEffects;
    private final Canvas m_canvas;
    private volatile Thread m_animationThread = null;
    private final int m_iGameWidth;
    private final int m_iGameHeight;
    private final Font m_smallFont;
    private final Font m_largeFont;
    private boolean m_bChangedField;
    private boolean m_bChangedKoloomn;
    private boolean m_bChangedNext;
    private boolean m_bChangedText;
    private boolean m_bHasBeenShown = false;
    private int m_iGameState = GAME_STATE_STOPPED;
    public byte[][] box;
    private Koloomn m_koloomn = null;
    private Koloomn m_next = null;
    private int m_iBoxWidth;
    private int m_iBoxHeight;
    private int m_iFieldLeft;
    private int m_iFieldTop;
    private int m_iFieldWidth;
    private int m_iFieldHeight;
    private int m_iPanelLeft;
    private int m_iPanelTop;
    private int m_iPanelWidth;
    private int m_iPanelCenter;
    private int m_iLevel;
    private int m_iSleepCounter;
    private int m_iGameCounter;
    private int m_iScore;
    private CRect m_searchRect = new CRect(0, 0, 6, 14);
    private CRect m_dropRect;
    private String m_sDebug = "";
    private int m_keyPressCounter = 0;

    public KolGame(KoloomnzMIDlet midlet, KolDictionary dictionary, GameEffects gameEffects, Canvas canvas) {
        this.m_midlet = midlet;
        this.m_dictionary = dictionary;
        this.m_gameEffects = gameEffects;
        this.m_canvas = canvas;
        this.m_iGameWidth = this.m_canvas.getWidth();
        this.m_iGameHeight = this.m_canvas.getHeight();
        ((SettableDelegate)this.m_canvas).setDelegate(this);
        this.m_smallFont = Font.getFont((int)64, (int)0, (int)8);
        this.m_largeFont = Font.getFont((int)64, (int)1, (int)0);
        this.m_iBoxWidth = this.m_iBoxHeight = this.m_canvas.getHeight() / 15;
        this.box = new byte[7][15];
        this.m_iFieldWidth = 7 * this.m_iBoxWidth;
        this.m_iFieldHeight = 15 * this.m_iBoxHeight;
        this.m_iFieldLeft = 4;
        this.m_iFieldTop = (this.m_canvas.getHeight() - this.m_iFieldHeight) / 2;
        this.m_iPanelLeft = this.m_iFieldLeft + this.m_iFieldWidth + 4;
        this.m_iPanelTop = 4;
        this.m_iPanelWidth = this.m_canvas.getWidth() - this.m_iFieldWidth - 12 - 1;
        this.m_iPanelCenter = this.m_iPanelLeft + this.m_iPanelWidth / 2;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteOutput);
        output.writeInt(this.m_iGameCounter);
        output.writeInt(this.m_iScore);
        output.writeInt(this.m_iLevel);
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 15) {
                output.writeByte(this.box[x][y]);
                ++y;
            }
            ++x;
        }
        output.write(this.m_next.getBytes());
        output.write(this.m_koloomn.getBytes());
        output.flush();
        return byteOutput.toByteArray();
    }

    private void continueGame(byte[] bytes) throws IOException {
        ByteArrayInputStream byteInput = new ByteArrayInputStream(bytes);
        DataInputStream input = new DataInputStream(byteInput);
        this.m_iGameCounter = input.readInt();
        this.m_iScore = input.readInt();
        this.m_iLevel = input.readInt();
        this.refreshSleepCounter();
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 15) {
                this.box[x][y] = input.readByte();
                ++y;
            }
            ++x;
        }
        this.m_next = new Koloomn(this);
        this.m_next.left = input.readInt();
        this.m_next.top = input.readInt();
        input.read(this.m_next.box, 0, 3);
        try {
            this.m_koloomn = new Koloomn(this);
            this.m_koloomn.left = input.readInt();
            this.m_koloomn.top = input.readInt();
            input.read(this.m_koloomn.box, 0, 3);
        }
        catch (EOFException ex) {
            this.m_koloomn = null;
        }
    }

    public boolean loadGame() {
        RecordStore store = null;
        RecordEnumeration enumeration = null;
        try {
            store = RecordStore.openRecordStore((String)"Koloomnz.Savegame", (boolean)true);
            enumeration = store.enumerateRecords(null, null, false);
            if (enumeration.hasNextElement()) {
                byte[] gameBytes = enumeration.nextRecord();
                enumeration.reset();
                this.continueGame(gameBytes);
                return true;
            }
        }
        catch (Exception ex) {}
        return false;
    }

    public boolean isPaused() {
        return this.m_iGameState == GAME_STATE_PAUSED;
    }

    public void saveGame() {
        RecordStore store = null;
        RecordEnumeration enumeration = null;
        try {
            store = RecordStore.openRecordStore((String)"Koloomnz.Savegame", (boolean)true);
            enumeration = store.enumerateRecords(null, null, false);
            if (enumeration.hasNextElement()) {
                store.deleteRecord(enumeration.nextRecordId());
            }
            if (this.m_iGameState != GAME_STATE_STOPPED) {
                byte[] gameBytes = this.getBytes();
                store.addRecord(gameBytes, 0, gameBytes.length);
            }
        }
        catch (Exception ex) {}
    }

    public Canvas getCanvas() {
        return this.m_canvas;
    }

    public int getScore() {
        return this.m_iScore;
    }

    public byte randomColor() {
        return (byte)(KolUtils.random(BOX_COLORS.length - 1) + 1);
    }

    public void newGame(int difficulty) {
        this.m_iGameCounter = 0;
        this.m_iScore = 0;
        this.m_iLevel = difficulty;
        this.refreshSleepCounter();
        this.m_koloomn = new Koloomn(this);
        this.m_next = new Koloomn(this);
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 15) {
                this.box[x][y] = -1;
                ++y;
            }
            ++x;
        }
    }

    public void endGame() {
        this.m_gameEffects.play(Sounds.SOUND_GAME_OVER);
        this.m_iGameState = GAME_STATE_STOPPED;
        this.m_koloomn = null;
        this.m_bChangedField = true;
        this.m_bChangedKoloomn = true;
        this.m_bChangedNext = true;
        this.m_bChangedText = true;
    }

    public synchronized boolean processAction(int gameAction) {
        if (this.m_iGameState == GAME_STATE_PAUSED && this.m_canvas.isShown()) {
            this.resume();
            return false;
        }
        if (this.m_iGameState == GAME_STATE_STOPPED) {
            return false;
        }
        if (this.m_koloomn == null) {
            return false;
        }
        boolean bResult = this.m_koloomn.processAction(gameAction);
        if (bResult) {
            this.m_bChangedKoloomn = true;
            this.repaint();
        }
        return bResult;
    }

    public void dropKoloomn() {
        this.m_gameEffects.play(Sounds.SOUND_KOLOOMN_DROP);
        this.m_bChangedField = true;
        int i = 0;
        while (i < 3) {
            this.box[this.m_koloomn.left][this.m_koloomn.top + i] = this.m_koloomn.box[i];
            ++i;
        }
        this.m_searchRect = new CRect(this.m_koloomn.left - 1, this.m_koloomn.top - 1, this.m_koloomn.left + 1, this.m_koloomn.top + 3);
        this.m_koloomn = null;
        this.m_iGameState = GAME_STATE_PROCESSING_SEARCH;
    }

    public void tick() {
        if (this.isDemoVersion()) {
            return;
        }
        if (this.m_iGameState == GAME_STATE_STOPPED) {
            this.m_koloomn = null;
            this.m_bChangedField = true;
            this.m_bChangedKoloomn = true;
            return;
        }
        ++this.m_iGameCounter;
        if (this.m_iLevel < 9 && this.m_iGameCounter >= 6000) {
            this.m_iGameCounter = 0;
            ++this.m_iLevel;
        }
        if (this.m_iGameState == GAME_STATE_ACTIVE) {
            if (this.m_koloomn == null) {
                if (this.m_next.checkGameOver()) {
                    this.endGame();
                    return;
                }
                this.m_koloomn = this.m_next;
                this.m_next = new Koloomn(this);
                this.m_bChangedKoloomn = true;
                this.m_bChangedNext = true;
            } else {
                --this.m_iSleepCounter;
                if (this.m_iSleepCounter <= 0) {
                    this.refreshSleepCounter();
                    if (this.m_koloomn.checkDropped()) {
                        this.dropKoloomn();
                    } else {
                        ++this.m_koloomn.top;
                        this.m_bChangedKoloomn = true;
                    }
                }
            }
        } else if (this.m_iGameState != GAME_STATE_PAUSED) {
            if (this.m_iGameState == GAME_STATE_PROCESSING_SEARCH) {
                if (this.processSearch()) {
                    this.m_bChangedField = true;
                    this.m_iGameState = GAME_STATE_PROCESSING_DESTROY;
                } else {
                    this.m_iGameState = GAME_STATE_ACTIVE;
                }
            } else if (this.m_iGameState == GAME_STATE_PROCESSING_DESTROY) {
                int iDestroyed = this.processDestroy();
                if (iDestroyed > 0) {
                    this.m_gameEffects.play(Sounds.SOUND_BLOCK_DESTROY);
                    this.m_bChangedField = true;
                    this.m_bChangedText = true;
                    if (iDestroyed >= 4 && iDestroyed <= 6) {
                        iDestroyed *= 2;
                    } else if (iDestroyed > 6) {
                        iDestroyed *= 3;
                    }
                    this.m_iScore += iDestroyed + this.m_iLevel;
                }
                this.m_iGameState = GAME_STATE_PROCESSING_DROP;
            } else if (this.m_iGameState == GAME_STATE_PROCESSING_DROP) {
                if (this.processDrop()) {
                    this.m_gameEffects.vibrate();
                    this.m_gameEffects.play(Sounds.SOUND_BLOCK_FALL);
                    this.m_bChangedField = true;
                } else {
                    this.m_iGameState = GAME_STATE_PROCESSING_SEARCH;
                }
            }
        }
    }

    private boolean processSearch() {
        byte iColor;
        boolean bResult = false;
        byte[][] aSearch = new byte[7][15];
        if (this.m_searchRect.left < 0) {
            this.m_searchRect.left = 0;
        }
        if (this.m_searchRect.top < 0) {
            this.m_searchRect.top = 0;
        }
        if (this.m_searchRect.right >= 7) {
            this.m_searchRect.right = 6;
        }
        if (this.m_searchRect.bottom >= 15) {
            this.m_searchRect.bottom = 14;
        }
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 15) {
                aSearch[x][y] = -1;
                ++y;
            }
            ++x;
        }
        int x2 = this.m_searchRect.left;
        while (x2 <= this.m_searchRect.right) {
            int y = this.m_searchRect.top;
            while (y <= this.m_searchRect.bottom) {
                iColor = this.box[x2][y];
                if (iColor != -1) {
                    int k = 1;
                    while (k <= 4) {
                        int dx = 0;
                        int dy = 0;
                        switch (k) {
                            case 1: {
                                dx = -1;
                                dy = -1;
                                break;
                            }
                            case 2: {
                                dx = -1;
                                dy = 1;
                                break;
                            }
                            case 3: {
                                dx = -1;
                                dy = 0;
                                break;
                            }
                            case 4: {
                                dx = 0;
                                dy = -1;
                            }
                        }
                        if (x2 + dx >= 0 && x2 + dx < 7 && x2 - dx >= 0 && x2 - dx < 7 && y + dy >= 0 && y + dy < 15 && y - dy >= 0 && y - dy < 15 && this.box[x2 - dx][y - dy] == iColor && this.box[x2 + dx][y + dy] == iColor) {
                            aSearch[x2 - dx][y - dy] = 0;
                            aSearch[x2 + dx][y + dy] = 0;
                            aSearch[x2][y] = 0;
                            bResult = true;
                        }
                        ++k;
                    }
                }
                ++y;
            }
            ++x2;
        }
        if (bResult) {
            int x3 = 0;
            while (x3 < 7) {
                int y = 0;
                while (y < 15) {
                    iColor = aSearch[x3][y];
                    if (iColor != -1) {
                        this.box[x3][y] = iColor;
                    }
                    ++y;
                }
                ++x3;
            }
        }
        return bResult;
    }

    private int processDestroy() {
        int iResult = 0;
        CRect r = this.m_searchRect.clone();
        --r.left;
        ++r.right;
        --r.top;
        ++r.bottom;
        if (r.left < 0) {
            r.left = 0;
        }
        if (r.top < 0) {
            r.top = 0;
        }
        if (r.right >= 7) {
            r.right = 6;
        }
        if (r.bottom >= 15) {
            r.bottom = 14;
        }
        this.m_dropRect = new CRect();
        int x = r.left;
        while (x <= r.right) {
            int y = r.top;
            while (y <= r.bottom) {
                if (this.box[x][y] == 0) {
                    this.box[x][y] = -1;
                    ++iResult;
                    if (this.m_dropRect.isEmpty()) {
                        this.m_dropRect.left = x;
                        this.m_dropRect.right = x;
                        this.m_dropRect.top = y;
                        this.m_dropRect.bottom = y;
                    } else {
                        if (x > this.m_dropRect.right) {
                            this.m_dropRect.right = x;
                        }
                        if (y < this.m_dropRect.top) {
                            this.m_dropRect.top = y;
                        }
                        if (y > this.m_dropRect.bottom) {
                            this.m_dropRect.bottom = y;
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
        this.m_searchRect = this.m_dropRect.clone();
        return iResult;
    }

    private boolean processDrop() {
        boolean bResult = false;
        int x = this.m_dropRect.left;
        while (x <= this.m_dropRect.right) {
            int y = this.m_dropRect.bottom;
            while (y >= 1) {
                if (this.box[x][y] == -1 && this.box[x][y - 1] != -1) {
                    if (this.m_searchRect.isEmpty()) {
                        this.m_searchRect.left = x - 1;
                        this.m_searchRect.right = x + 1;
                        this.m_searchRect.top = y - 1;
                        this.m_searchRect.bottom = y + 1;
                    } else {
                        if (x - 1 < this.m_searchRect.left) {
                            this.m_searchRect.left = x - 1;
                        }
                        if (x + 1 > this.m_searchRect.right) {
                            this.m_searchRect.right = x + 1;
                        }
                        if (y + 1 > this.m_searchRect.bottom) {
                            this.m_searchRect.bottom = y + 1;
                        }
                    }
                    int top = 0;
                    int y1 = y;
                    while (y1 >= 1) {
                        byte color;
                        this.box[x][y1] = color = this.box[x][y1 - 1];
                        if (color == -1) {
                            top = y1;
                            break;
                        }
                        --y1;
                    }
                    if (top - 1 < this.m_searchRect.top) {
                        this.m_searchRect.top = top - 1;
                    }
                    bResult = true;
                    break;
                }
                --y;
            }
            ++x;
        }
        return bResult;
    }

    private void drawGame(Graphics g) {
        if (this.isDemoVersion()) {
            this.drawDemoVersion(g);
            return;
        }
        if (this.m_iGameState == GAME_STATE_STOPPED) {
            this.drawGameOver(g);
            this.m_bChangedField = false;
            this.m_bChangedKoloomn = false;
            this.m_bChangedNext = false;
            this.m_bChangedText = false;
            return;
        }
        if (this.m_bChangedField && this.m_bChangedText) {
            int width = this.m_canvas.getWidth();
            int height = this.m_canvas.getHeight();
            g.setColor(0xBBBBBB);
            g.fillRect(0, 0, width, height);
        }
        if (this.m_bChangedField) {
            this.drawField(g);
        }
        int iAnchor = 1 | 0x10;
        int iTop = this.m_iPanelTop;
        if (this.m_bChangedNext) {
            g.setFont(this.m_smallFont);
            g.drawString(this.m_dictionary.getString(KolDictionary.LABEL_NEXT), this.m_iPanelCenter, iTop, iAnchor);
        }
        iTop += this.m_smallFont.getHeight();
        iTop += 3 * this.m_iBoxHeight + 4;
        if (this.m_bChangedText) {
            g.setFont(this.m_smallFont);
            g.drawString(this.m_dictionary.getString(KolDictionary.LABEL_LEVEL), this.m_iPanelCenter, iTop, iAnchor);
            g.setFont(this.m_smallFont);
            g.drawString(String.valueOf(this.m_iLevel), this.m_iPanelCenter, iTop += this.m_smallFont.getHeight(), iAnchor);
            g.setFont(this.m_smallFont);
            g.drawString(this.m_dictionary.getString(KolDictionary.LABEL_SCORE), this.m_iPanelCenter, iTop += this.m_smallFont.getHeight() + 4, iAnchor);
            g.setFont(this.m_smallFont);
            g.drawString(String.valueOf(this.m_iScore), this.m_iPanelCenter, iTop += this.m_smallFont.getHeight(), iAnchor);
        }
        if (this.m_bChangedKoloomn && this.m_koloomn != null) {
            if (!this.m_bChangedField) {
                this.drawField(g);
            }
            this.drawKoloomn(g, this.m_koloomn);
        }
        if (this.m_bChangedNext) {
            this.drawKoloomn(g, this.m_next);
        }
        this.m_bChangedField = false;
        this.m_bChangedKoloomn = false;
        this.m_bChangedNext = false;
        this.m_bChangedText = false;
        if (this.m_sDebug != "") {
            g.setColor(0);
            g.setFont(this.m_smallFont);
            g.drawString(this.m_sDebug, this.m_iGameWidth, this.m_iGameHeight, 0x20 | 8);
        }
    }

    private void drawField(Graphics g) {
        this.drawPanel(g, this.m_iFieldLeft, this.m_iFieldTop, this.m_iFieldWidth, this.m_iFieldHeight);
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 15) {
                byte color = this.box[x][y];
                if (color != -1) {
                    this.drawBox(g, this.m_iFieldLeft, this.m_iFieldTop, x, y, color);
                }
                ++y;
            }
            ++x;
        }
        g.setClip(0, 0, this.m_iGameWidth, this.m_iGameHeight);
    }

    private void drawKoloomn(Graphics g, Koloomn k) {
        int iTop;
        int iLeft;
        if (k == null) {
            return;
        }
        if (k == this.m_next) {
            iLeft = this.m_iPanelCenter - k.left * this.m_iBoxWidth - this.m_iBoxWidth / 2;
            iTop = this.m_iPanelTop - k.top * this.m_iBoxHeight + this.m_smallFont.getHeight();
        } else {
            iLeft = this.m_iFieldLeft;
            iTop = this.m_iFieldTop;
        }
        int i = 0;
        while (i < 3) {
            this.drawBox(g, iLeft, iTop, k.left, k.top + i, k.box[i]);
            ++i;
        }
    }

    private void drawBox(Graphics g, int left, int top, int col, int row, byte color) {
        int x = left + col * this.m_iBoxWidth;
        int y = top + row * this.m_iBoxHeight;
        if (color == -1) {
            g.setColor(0xFFFFFF);
        } else {
            g.setColor(BOX_COLORS[color]);
        }
        g.fillRect(x, y, this.m_iBoxWidth, this.m_iBoxHeight);
        if (color != -1) {
            g.setColor(0);
            g.drawRect(x, y, this.m_iBoxWidth, this.m_iBoxHeight);
        }
    }

    private void refreshSleepCounter() {
        this.m_iSleepCounter = (9 - this.m_iLevel) * 15 + 10;
    }

    private void drawFrame(Graphics g, int x, int y, int width, int height) {
        g.setColor(0);
        g.drawRect(x, y, width, height);
    }

    private void drawPanel(Graphics g, int x, int y, int width, int height) {
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, width, height);
        this.drawFrame(g, x, y, width, height);
    }

    private void drawGameOver(Graphics g) {
        this.drawPanel(g, 0, 0, this.m_iGameWidth - 1, this.m_iGameHeight - 1);
        int height = this.m_largeFont.getHeight() * 1 + this.m_smallFont.getHeight() * 3;
        int top = (this.m_iGameHeight - height) / 2;
        int center = this.m_iGameWidth / 2;
        int anchor = 17;
        g.setColor(0);
        g.setFont(this.m_largeFont);
        g.drawString(this.m_dictionary.getString(KolDictionary.TEXT_GAME_OVER), center, top, anchor);
        g.setFont(this.m_smallFont);
        g.drawString(this.m_dictionary.getString(KolDictionary.TEXT_YOUR_SCORE) + ": " + String.valueOf(this.m_iScore), center, top += this.m_largeFont.getHeight(), anchor);
        g.drawString(this.m_dictionary.getString(KolDictionary.TEXT_GAME_QUIT_PROMPT), center, top += this.m_smallFont.getHeight() * 2, anchor);
        top += this.m_smallFont.getHeight();
    }

    private boolean isDemoVersion() {
        return this.m_keyPressCounter % 20 == 0;
    }

    private void drawDemoVersion(Graphics g) {
        this.drawPanel(g, 0, 0, this.m_iGameWidth - 1, this.m_iGameHeight - 1);
        int height = this.m_largeFont.getHeight() * 1 + this.m_smallFont.getHeight() * 4;
        int top = (this.m_iGameHeight - height) / 2;
        int center = this.m_iGameWidth / 2;
        int anchor = 17;
        g.setColor(0xFF0000);
        g.setFont(this.m_largeFont);
        g.drawString("Demo version!", center, top, anchor);
        g.setColor(0);
        g.setFont(this.m_smallFont);
        g.drawString("visit our web site:", center, top += this.m_largeFont.getHeight(), anchor);
        g.drawString("www.javamobilesoft.com", center, top += this.m_smallFont.getHeight(), anchor);
        g.drawString("Press any key...", center, top += this.m_smallFont.getHeight() * 2, anchor);
        this.pause();
    }

    public void start() {
        this.m_bChangedField = true;
        this.m_bChangedKoloomn = true;
        this.m_bChangedNext = true;
        this.m_bChangedText = true;
        this.m_iGameState = GAME_STATE_PROCESSING_SEARCH;
        this.m_bHasBeenShown = false;
        this.m_animationThread = new Thread(this);
        this.m_animationThread.start();
        this.m_gameEffects.setUseSound(Settings.getUseSound());
        this.m_gameEffects.setUseVibration(Settings.getUseVibration());
        this.m_gameEffects.resume();
    }

    public void stop() {
        this.m_animationThread = null;
        this.saveGame();
        this.m_gameEffects.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        KolGame kolGame = this;
        synchronized (kolGame) {
            this.m_iGameState = GAME_STATE_PAUSED;
        }
        this.m_gameEffects.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        KolGame kolGame = this;
        synchronized (kolGame) {
            this.m_bHasBeenShown = false;
            this.m_iGameState = GAME_STATE_PROCESSING_SEARCH;
            this.m_bChangedField = true;
            this.m_bChangedKoloomn = true;
            this.m_bChangedNext = true;
            this.m_bChangedText = true;
        }
        this.m_gameEffects.setUseSound(Settings.getUseSound());
        this.m_gameEffects.setUseVibration(Settings.getUseVibration());
        this.m_gameEffects.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTaken;
                if (currentThread != this.m_animationThread) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.m_iGameState == GAME_STATE_PAUSED) continue;
                if (this.m_canvas.isShown()) {
                    if (!this.m_bHasBeenShown) {
                        this.m_bHasBeenShown = true;
                    }
                    this.tick();
                } else if (this.m_bHasBeenShown) {
                    this.pause();
                }
                if (this.m_canvas.isShown() && (this.m_bChangedField || this.m_bChangedKoloomn || this.m_bChangedNext || this.m_bChangedText)) {
                    this.repaint();
                }
                if ((timeTaken = System.currentTimeMillis() - startTime) < 10L) {
                    KolGame kolGame = this;
                    synchronized (kolGame) {
                        this.wait(10L - timeTaken);
                        continue;
                    }
                }
                currentThread.yield();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void repaint() {
        this.m_canvas.repaint(0, 0, this.m_iGameWidth, this.m_iGameHeight);
        this.m_canvas.serviceRepaints();
    }

    public void keyPressed(int keyCode) {
        ++this.m_keyPressCounter;
        if (!this.isDemoVersion()) {
            this.processAction(this.m_canvas.getGameAction(keyCode));
        } else {
            this.m_bChangedField = true;
            this.m_bChangedKoloomn = true;
            this.m_bChangedNext = true;
            this.m_bChangedText = true;
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void paint(Graphics g) {
        this.drawGame(g);
    }

    public void closePressed() {
        boolean bGameOver;
        boolean bl = bGameOver = this.m_iGameState == GAME_STATE_STOPPED;
        if (bGameOver) {
            this.stop();
        } else {
            this.pause();
        }
        this.m_midlet.gameManagerMainMenu(bGameOver);
    }
}

