//
//  XTTextTab.m
//  XTads
//
//  Created by Rune Berg on 09/01/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import "XTTextTab.h"
#import "XTTabStopModelEntry.h"
#import "XTAllocDeallocCounter.h"
#import "XTLogger.h"


@interface XTTextTab ()

@property NSMutableDictionary *customOptions;
@property NSUInteger serialNo;

@end


@implementation XTTextTab

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

static XTLogger* logger;

static NSUInteger nextSerialNo;

+ (void)initialize
{
	if (self == [XTTextTab class]) {
		logger = [XTLogger loggerForClass:[XTTextTab class]];
		nextSerialNo = 0;
	}
}

- (instancetype)initWithTextAlignment:(NSTextAlignment)alignment location:(CGFloat)loc options:(NSDictionary<NSTextTabOptionKey,id> *)options
{
	self = [super initWithTextAlignment:alignment location:loc options:options];
	if (self) {
		_customOptions = [NSMutableDictionary dictionary];
		_serialNo = nextSerialNo;
		nextSerialNo += 1;
	}
	return self;
}

- (BOOL)isEqual:(id)other
{
	if (other == self) {
		return YES;
		
	} else if (![super isEqual:other]) {
		return NO;
		
	} else {
		BOOL res;
		XTTextTab *castOther = nil;
		if ([other isKindOfClass:[XTTextTab class]]) {
			castOther = (XTTextTab *)other;
			res = [self hasSameCustomOptionAs:castOther forKey:XT_TAB_TYPE_KEY] &&
				  [self hasSameCustomOptionAs:castOther forKey:XT_TAB_ID_KEY] &&
				  [self hasSameCustomOptionAs:castOther forKey:XT_TAB_MULTIPLE_KEY] &&
				  (self.serialNo == castOther.serialNo);
		} else {
			XT_DEF_SELNAME;
			XT_ERROR_0(@"other is not a XTTextTab");
			res = NO;
		}
		return res;
	}
}

- (BOOL)hasSameCustomOptionAs:(XTTextTab *)other
					   forKey:(NSString *)key
{
	id valueSelf = [self getCustomOptionForKey:key];
	id valueOther = [other getCustomOptionForKey:key];

	BOOL res;
	if (valueSelf != nil) {
		if (valueOther != nil) {
			res = [valueSelf isEqual:valueOther];
		} else {
			res = NO;
		}
	} else {
		// valueSelf == nil
		res = (valueOther == nil);
	}
	return res;
}

- (NSUInteger)hash
{
	NSUInteger resSuper = [super hash];
	NSUInteger res = resSuper;
	if (self.customOptions != nil) {
		res = resSuper + [self.customOptions hash];
	}
	res += self.serialNo;
	return res;
}

+ (XTTextTab *)withTextAlignment:(NSTextAlignment)alignment
						location:(CGFloat)loc
						 options:(NSDictionary<NSString *, id> *)options
				   customOptions:(NSDictionary<NSString *, id> *)customOptions
{
	if (options == nil) {
		options = [NSDictionary dictionary];  //TODO !!! adapt use common empty dict.
	}
	XTTextTab *tab = [[XTTextTab alloc] initWithTextAlignment:alignment location:loc options:options];
	tab.customOptions = [NSMutableDictionary dictionaryWithDictionary:customOptions];
	return tab;
}

- (id)getCustomOptionForKey:(NSString *)key
{
	id res = nil;
	if (self.customOptions != nil) {
		res = [self.customOptions objectForKey:key];
	}
	return res;
}

- (NSDictionary<NSString *, id> *)getCustomOptions
{
	return self.customOptions;
}

- (void)removeCustomOptions
{
	[self.customOptions removeAllObjects];
}

@end
