//
//  XTHtmlTagSecondOutermost.m
//  XTads
//
//  Created by Rune Berg on 05/07/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTHtmlTagSecondOutermost.h"
#import "XTHtmlTagContainer_private.h"
#import "XTLogger.h"


@implementation XTHtmlTagSecondOutermost

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTHtmlTagSecondOutermost class]];
}

+ (NSString *)name
{
	return @"XTHtmlTagSecondOutermost";
}

- (void)checkNotHasFormatted
{
	// Nothing
}

- (void)noteHasFormatted
{
	// Nothing
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	int brkpt = 1;
}


// Make sure we keep a not yet closed container tag if that tag is last in our contents.
- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	//XT_WARN_ENTRY;
	
	XTHtmlTagContainer *openContainerLastInContent = nil;
	XTHtmlTag *lastInContent = self.contents.lastObject;
	if (lastInContent != nil && [lastInContent isKindOfClass:[XTHtmlTagContainer class]]) {
		XTHtmlTagContainer *containerLastInContent = (XTHtmlTagContainer *)lastInContent;
		if (! containerLastInContent.closed) {
			openContainerLastInContent = containerLastInContent;
		}
	}
	
	[self postFormatForBlockLevel:formatter textHandler:textHandler];
	[self removeChildren];

	if (openContainerLastInContent != nil) {
		[self appendToContents:openContainerLastInContent];
	}
}

@end
