//
//  XTHtmlTagOutermost.m
//  XTads
//
//  Created by Rune Berg on 11/05/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTHtmlTagOutermost.h"
#import "XTHtmlTag_private.h"
#import "XTHtmlTagContainer_private.h"
#import "XTHtmlTagSecondOutermost.h"
#import "XTLogger.h"


@implementation XTHtmlTagOutermost

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTHtmlTag class]];
}

+ (NSString *)name
{
	return @"XTHtmlTagOutermost";
}

- (void)removeFromContainer
{
	// Nothing - we are never in a container
}

- (void)assertHasContainer
{
	// We're the root, and should not have a container
	if (self.container != nil) {
		XT_DEF_SELNAME;
		XT_ERROR_0(@"self.container == nil");
	}
}

- (void)checkNotHasFormatted
{
	// Nothing
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	//TODO !!! set default color scheme - see htmltags.cpp l.780
}

- (void)noteHasFormatted
{
	// Nothing
}

- (void)removeChildren
{
	// Nothing - always keep our one child
}

@end
