#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

guardian : Person '(prison) lithe guardian/guard/man' 'guardian'
 @guardChair
 "The guardian is a lithe, athletic-looking man in his mid-thirties, with short
  fair hair and a hard, unsympathetic face. He's dressed in a pale grey uniform,
  which, according to the badge above his left breast pocket, would seem to be
  that of the New Enlightenment Punishment Service. "
  posture = sitting
 isHim = true
 dobjFor(Attack) { action() {  attackList.doScript;  } }
 dobjFor(AttackWith)  { action() {  attackList.doScript;  } }
 iobjFor(ThrowAt)
 {
   action()
   {
      if(gDobj == sandwich)
        replaceAction(GiveTo, sandwich, self);
      else if(gDobj is in (note, foodNote))
         "The guardian appears not to notice. ";
      else
      {
       "As {the dobj/he} strikes {the iobj/him} square in the chest, he grins
       broadly, <q>You just made my day! I just <i>love</i> it when I have a good
       excuse to do this...</q>\b
       Without further ado, he whips out his machine-pistol and empties its
       magazine into your heart.\b";
       endGame(ftDeath);
      }
   }
 }
 attackList : EventList {
  [
   'You launch a futile attack on the guardian with ' + (gIobj == nil ? 
    bodyPart : gIobj.theName) + ', which he has no difficulty beating off.\b
    <q>Try that again and I\'ll shoot you.</q> he warns you. ',
   new function {
     "You raise <<gIobj == nil ? 'your fist' : '{the iobj/him}' >> to strike the guardian. 
      In response he draws out his machine-pistol and shoots you through the heart. ";
      endGame(ftDeath);
   }
  ]
   bodyPart {
      return gVerbName=='kick' ? 'your feet' : 'your bare fists';  
 }
 }
 distantSpecialDesc { curState.distantSpecialDesc; }
 afterAction()
 {
   inherited;
   if(gActionIs(Yell))
   {
     "<.p><q>You can shout all you like, but it won't do you the remotest bit of 
      good,</q> the guardian remarks dispassionately.<.p>";
   }
 }
 checkTakeFromInventory(actor, obj)
 {
   if(obj==pistol)
   {
     "There's absolutely no way {the guardian/he} is
        going to let you so much as touch his weapon. ";
     exit;   
   }
   inherited(actor, obj);
 }
 globalParamName = 'guardian'
 cannotKissActorMsg = 'Funnily enough, you really don\'t feel that much affection
   for him. This lack of affection is almost certainly mutual. '
 cannotTakeMsg = 'Even assuming he\'d allow that -- which he obviously wouldn\'t   
  -- the guardian looks rather too big for you to pick up and sling over your shoulder. '
 feelDesc = "Neither of you could tolerate that kind of intimacy. "
 smellDesc = "A curious and not especially pleasing mix of this morning's bath-soap
  with a subsequent sweaty overlay. "
 thankResponse = "<q>Thank you <i>so</i> much,</q> you say.\b
  <q>Don't you get sarcastic with me!</q> he snaps. "
 
;

+ holster : Wearable, RestrictedContainer 'black holster' 'black holster'
  "The large black leather holster is strapped to the guardian's right hip. "
  validContents = [pistol]
  wornBy = guardian
;

++ pistol : Thing '(machine) pistol/gun/machine-pistol' 'machine-pistol'
  desc()
  {
    if(isIn(holster))
      "The large black butt of the machine-pistol can just be seen poking out
       of the top of the holster. ";
    if(isHeldBy(guardian))
      "It's a large, black, ugly weapon, with a heavy grip and a short, stubby
        barrel. By far the worst thing about it, however, is that it's pointed
        straight at you. ";
  }  
;

+ Wearable 'reasonably drab smart pale grey uniform/tunic/trousers/pants' 'grey uniform'
  "It's a drab, though reasonably smart, uniform consisting of pale grey
   trousers and a tunic of the same colour. The tunic has a pair of breast pockets,
   with a badge above the left one. "
  wornBy = guardian
  cannotTakeMsg = 'The guardian\'s hardly going to let you strip him!'
;

++ Component 'breast pair/pockets' 'breast pockets'
  "They're just a pair of pockets, with a badge above the left one. "
  isPlural = true
;

++ Component 'badge/inscription' 'badge'
  "The badge bears the inscription NEW ENLIGHTENMENT PUNISHMENT SERVICE and depicts
    a set of prison gates and a sword. "
;

+++ Component 'stylized sword/hilt/blade' 'sword'
  "The highly stylized sword is depicted hilt up and to the left, with its blade
   interlacing the prison gates. "
;

+++ Component '(badge) prison vertical series/gates/bars' 'prison gates'
   "The prison gates are depicted on the badge mainly by a series of
    vertical bars. "
   isPlural = true
   disambigName = 'badge prison gates'
; 


+ GiveShowTopic @sandwich
  topicResponse
  {
    "The guardian snatches the sandwich from your grasp proceeds to eat it.\b
     <q>Hey! That was my entire food ration!</q> you protest.\b
     <q>As you say, it <i>was</i> your entire food ration,</q>
       he agrees, <q>Now you'll just be a bit hungrier!</q><.reveal guard-eat>";
    sandwich.moveInto(nil);
  }
;

+ GiveShowTopic @pen
  topicResponse
  {
    "<q>I'd better take that, it's government property!</q> he snaps snatching
     the pen from your grasp and slipping it into his pocket. ";
     pen.moveInto(nil);
  }
  isActive = (globe.squareCircleDrawnOn != nil)
;

+ DefaultCommandTopic, ShuffledEventList
  [
    '<q>You\'re hardly in a position to tell me what to do,</q> he points out. ',
    
    '<q>I don\'t take orders from criminals,</q> he tells you. ',
    
    '<q>Your attempt to order me around is a clear sign of your chronic social
     deviance,</q> {the guardian/he} remarks. ',
     
    '<q>You take orders; you don\'t give them,</q> he replies coldly. '
  ]
;


+ DefaultGiveShowTopic
  "You show <<gDobj.theName>> to the guardian, but he seems quite
  unimpressed. "
;

+ ConvNode 'square' limitSuggestions = true ;

++ SpecialTopic 'tell him it\'s a square' 
  ['tell', 'him', 'the', 'guard', 'guardian', 'that', 'it\'s', 'its', 'it', 'is', 'a',
     'about' ,'square']
  
    "<q>So, it's made up of four lines.</q> you point out, tracing each of the lines
      with your finger.\b
     <q>Yes, I suppose it is -- so?</q> he asks.\b
     <q>Each of the lines is equal, and the angle between each adjacent pair of
       lines is equal.</q> you continue.\b
     <q>True.</q> the guardian concedes.\b
     <q>But a figure with four equal lines and four equal angles is a square.</q> you
     point out triumphantly.\b     
     <q>But the lines aren't <i>straight</i>!</q> he protests.<.p><.convnode line>"
     
;

++ SpecialTopic 'ask him what he thinks' 
   ['ask', 'him', 'guard', 'guardian' , 'what', 'he', 'thinks', 'do', 'you', 'think']
   "<q>So, what do do think of that?</q> you ask.\b
    The guardian scratches his head with a puzzled frown. <q>No idea -- what am I
    <i>meant</i> to think?</q> he replies, <q>You\'ve drawn a circle round a
    sphere; so what?</q> <.convstay><.topics>"
;

++ SpecialTopic 'discuss geography' ['discuss', 'geography']
   "<q>Whoever made this globe didn't know much about what was below the equator.</q>
    you point out, <q>The southern hemisphere is all over the place.</q>\b
    <q>Really?</q> the guardian yawns, <q>I've never been there myself, so I wouldn't
    know.</q><.p><.convstay><.topics>"
;


++ DefaultAnyTopic
   "<q>We were talking about this globe.</q> the guardian reminds you. <.convstay><.topics>"
;

+ ConvNode 'line' limitSuggestions = true ;

++ SpecialTopic 'admit defeat' ['admit', 'defeat']
  "<q>No, I suppose they're not.</q> you concede.\b
   <q>Nice try.</q> the guardian smirks, <q>if you could only draw four <i>straight</i>
    lines in a circle you'd have done it.</q> he reaches for his paper again, <q>Will
    that be all?</q><.convnode accept-defeat><.topics>"
;

++ SpecialTopic 'define straight line' ['define', 'straight', 'line' ]     
     "<q>A straight line is the shortest distance between two points, right?</q> you ask.\b
     <q>Right.</q> he agrees.\b
     <q>And the shortest distance between two points on the surface of a sphere is
       along a great circle.</q> you add.\b
     <q>So the lines are straight.</q> he muses, <q>And there are four of them, and
      they are equal, and the four angles are equal...</q><.convnode square-circle>"      
;

++ SpecialTopic 'ask why not' ['ask', 'him', 'why', 'not']
   "<q>What do you mean, they're not straight?</q> you retort, <q>You try to draw them
    any straighter on the surface of a globe!</q>\b
    <q>I wouldn't know where to begin.</q> he admits cheerfully, <q>But it seems you
     don't either. So let's just accept that your lines aren't straight and you've
     failed in your task. Right?</q><.convnode accept-defeat><.topics>"
;


++ DefaultAnyTopic
   "<q>Let's stick to the point: your lines aren\'t straight.</q> the guardian insists. 
    <.convstay><.topics>"
;

+ ConvNode 'square-circle' limitSuggestions = true ;

++ SpecialTopic 'claim the circle is a square' 
     ['claim', 'that', 'the', 'circle', 'is', 'a', 'square']    
     "<q>So the figure is a square.</q> you declare.\b
     <q>Well, yes, perhaps it is.</q> the guardian concedes, <q>But then it can't really
      be a circle, can it? I mean, it may <i>look</i> like a circle, but you've just
      shown that it's made up of four straight lines, and something made up of four
      straight lines <i>can't</i> be a circle! You're just trying to trick me. Nice
      try, but you'll have to do better than that!</q> he chuckles. <.convnode define-circle>"
;     

++ SpecialTopic 'ask what he concludes' 
   ['ask', 'him', 'what', 'he', 'concludes', 'do', 'you', 'conclude']
   "<q>So what do you conclude from that?</q> you enquire.\b
    <q>Er, let me see.</q> the guardian mutters, <q>You've drawn four lines round this
     globe, and they're each the same length, and the four angles are the same, and
     each line is the shortest distance between two points, so it <i>must</i> be a square.</q>
    he pauses for a moment, frowning thoughtfully, then suddenly brightens, <q>Aha! I
    see how you\'re trying to trick me! If the lines are straight it can\'t really be
    a circle, can it? It just looks like a circle in Euclidean space, but you're
    employing a non-Euclidean geometry to make the lines straight. You can't have it
    both ways, you know. Nice try, though.</q> he chuckles. <.convnode define-circle><.topics>"
;



++ DefaultAnyTopic
  "<q>You were talking about what you've just drawn on this globe.</q> the guardian
   reminds you, <q>Don't try to change the subject!</q><.convstay><.p>"
;


+ ConvNode 'accept-defeat' limitSuggestions = true ;

++ YesTopic, SuggestedYesTopic
  "<q>I guess so.</q> you concede dejectedly.\b
   <q>Right.</q> the guardian picks up his paper and begins to read once more.<.p>"
;

++ NoTopic, SuggestedNoTopic
  "<q>Not quite.</q> you reply hastily.
  The guardian lowers his paper with a heavy sigh, <q>But the lines you've drawn aren't
  straight.</q> he reminds you, <q>Unless they're straight, you haven't drawn a
  square.</q><.p><.convnode line>"
;

++ DefaultAnyTopic
   "<q>Yes or no?</q> prompts the guardian, peering over the top of his paper.<.convstay>"
;

+ ConvNode 'define-circle'
 limitSuggestions = true 
;

++ SpecialTopic 'admit defeat' ['admit', 'defeat']
  "<q>Oh well, back to the drawing board,</q> you say,\b
   <q>Have fun!</q> smirks the guardian."
;

++ SpecialTopic 'define circle' ['define', 'circle']
  topicResponse()
    {
   "<q>A circle is a figure bounded by a circumference every point of which is
    equidistant from the centre.</q> you point out.\b
    <q>True.</q> the guardian concedes.\b
    <q>And every point of the equator is equidistant from the pole.</q> you continue.\b
    <q>True.</q> the guardian repeats.\b
    <q>So a line drawn round the equator <i>is</i> a circle.</q> you conclude.\b
    <q>Yes.</q> he admits.\b
    <q>But we've already agreed it's a square, so I must have drawn a square circle.</q>
    you conclude.\b
    The guardian scratches his head in bemusement for a few moments, and then nods,
      saying, <q>Very well, you win, it's a square circle. So, you're free to
      go. Me -- I'm out of here. And I suppose I'd better take the globe just to prove
      to my superiors that you've fulfilled your task. ";
      
    /* Experimental code to take pen out of circulation */  
    if(guardian.canSee(pen))   
    {      
      "And while I'm at it I'd better take that too,</q> he adds, snatching the
       pen<<pen.isIn(gPlayerChar) ? ' from your grasp' : ''>> and slipping it
       into his pocket, <q>it's government property!";
       pen.moveInto(nil);
    }  
    "</q>\bSo saying he carefully folds his newspaper, stands up, takes the globe,
     and walks briskly out into the courtyard.<.p>"; 
    globe.moveInto(nil);  
    newspaper.moveInto(nil);
    outputManager.curOutputStream.captureOutput( new function {
       nestedActorAction(guardian, GetOffOf, guardChair);       
       nestedActorAction(guardian, North);        
       guardian.moveIntoForTravel(nil);  
    });
    guardianPaperNoise.moveInto(nil);
    achievement.awardPointsOnce();
  }
   achievement : Achievement { +1 " persuading the guardian that you've drawn a square circle " }
;

++ DefaultAnyTopic
   "<q>Is that relevant?</q> asks the guardian, <q>I was pointing out that your square
    isn't really a circle.</q><.convstay><.p>"
;

+ guardianTalking : InConversationState
  specialDesc = "The guardian is sitting talking with you, with his newspaper strewn
   over his lap. "
   beforeTravel(traveler, connector)
  {
    if(connector == wayOut.north && traveler not in (guardian, whiteCoat) )
    {
      "The guardian blocks your path, growling <q>Not thinking of going somewhere,
       are you?</q><.convnode not-going-somewhere>";
      exit;
    }
    else
      inherited(traveler, connector);
  }
  beforeAction()
  {
    if(gActionIs(Open) && gDobj==smallPanel)
    {
      "<q>Leave it alone!</q> snaps the guard, knocking your hand aside. ";
      exit;
    }
    inherited;
  }
;


++ guardianGuarding : ConversationReadyState
  specialDesc = "A prison guardian is sitting in the chair, reading a newspaper. "
  stateDesc = "He's reading the latest edition of the <i>Rational
    News.</i> "
  isInitState = true
   beforeTravel(traveler, connector)
  {
    if(connector == wayOut.north && traveler == gPlayerChar)
    {
      "Without looking up from his paper, the guardian sticks his leg out across
       the passage to block your path, drawling <q>No square circle, no exit!</q>.";
      exit;
    }
    else
     inherited(traveler, connector);
  } 
  beforeAction()
  {
    if(!gActionIs(Examine) && gDobj is in (smallPanel, smallNut, redButton ))
    {
      "<q>Leave it alone!</q> snaps the guard, knocking your hand aside. ";
      exit;
    }
    inherited;
  }
;

+++ HelloTopic, ShuffledEventList
  [ '<q>Excuse me.</q> you say.\bThe guardian slowly lowers his newspaper and looks at
      you over the top. <q>Yes?</q> he asks.' 
  ]    
  [ 
     'The guardian puts his paper down with evident irritation. <q>Can\'t a fellow
      get <i>any</i> peace round here?</q> he complains.<.p>',
      
     'The guardian thumps his paper down and snaps, <q>What now?</q><.p>',
     
     '<q>This has better be good.</q> the guardian growls ominously as he eyes you
       hungrily over the top of his paper.<.p>'
   ]
;

+++ ByeTopic
   "The guardian picks up his paper and resumes reading. ";
;

++ AskTellTopic [t_food, sandwich]
   "<q>When do I get something to eat?</q> you ask.\b
    <q>Your rations are back in there.</q> he growls, nodding back down the passage."
;

+++ AltTopic, StopEventList
   [
   '<q>I\'ve just found a sandwich and a note -- the note says that the sandwich is my
    entire food ration! That\'s not enough -- I\'ll starve!</q> you protest.\b
    <q>The note also told you not to complain.</q> the guardian points out.<.p>',
   '<q>But what am I meant to do?</q> you ask, <q>That sandwich won\'t even last me 
     a day!</q>\b
     <q>Then you\'d better hurry up with that square circle.</q> he advises
      you.',
      
   '<q>What if I just <i>can\'t</i> draw a square circle?</q> you protest, <q>Do I just
     starve?</q>\b
    <q>That\'s right.</q> the guardian agrees, <q>You just starve.</q> ',
      
   '<q>I\'m hungry -- I must have more food!</q> you insist.\b
    The guardian responds with a mirthless smile and taps his holster, <q>Starving
     is a slow way to go -- but there is an alternative.</q> he suggests, <q>Just go
     for me and I\'ll shoot you clean and quick!</q>',
     
   '<q>I\'m starving, I demand more food!</q> you complain.\b
    The guardian taps his holster, <q>Clean and quick,</q> he repeats,
    <q>Clean and quick.</q>'
   ]
   isActive = (foodNote.described)    
;

+++ AltTopic, StopEventList
  [
    '<q>What else is there for me to eat?</q> you ask.\b
     <q>Nothing -- I just ate your whole ration!</q> the guardian replies cheerfully. ',
     
    '<q>If you\'ve just eaten my ration you should replace it!</q> you demand.\b
     <q>And how do you think you\'re going to make me?</q> he replies.',
     
    '<q>I demand you replace my food ration!</q> you say.\b
     <q>Or what?</q> the guardian sneers, <q>You\'ll complain? Who to? And what
      can you say? You <i>gave</i> me that sandwich!</q>',
      
    '<q>You mean I\'m not going to get <i>any</i> more food?</q> you ask.\b
     <q>That\'s right,</q> the guardian grins complacently.'  
  ]
  isActive = (gRevealed('guard-eat'))
;


++ AskTellTopic, SuggestedAskTopic, StopEventList [t_justice, t_crime, t_punishment]
   [
     '<q>Why am I being held here? What have I done?</q> you demand to know.\b
      The guardian gives a careless shrug. <q>Whatever it is, you can be sure
      you\'re getting the punishment you deserve. The state is never wrong.</q>
      he assures you.',
      
     '<q>I demand to know what crime I\'m being held for!</q> you insist.\b
      The guard barely suppresses a chortle. <q>You\'re hardly in any position to
       make demands, in case you hadn\'t noticed.</q> he points out.',       
       
     '<q>This is unjust! I\'m being punished and I don\'t even know what
      for!</q> you complain.\b
      <q>The fact that you question the justice of your punishment only
       confirms that you have a criminal mind.</q> the guard replies evenly,
       <q>No law-abiding citizen would question the rationality of the state.</q>',
      
      '<q>Look, I think there\'s been a miscarriage of justice here.</q> you
      plead.\b
       <q>I doubt it.</q> he replies. ',      
      
      '<q>I still say my sentence is unfair.</q> you complain.\b
       <q>I think we\'ve exhausted that topic.</q> the guardian tells you.'    
   ]
   name = 'crime'
; 

++ AskTopic @t_criminals
  "<q>Are there so many criminals, then?</q> you ask.\b
   <q>Too many -- we haven't had time to stamp them all out yet,</q> he replies,
   <q>But don't worry, we will!</q> he adds with a threatening glare. "
;

++ AskTopic @t_contract
  "<q>So, what is in your contract?</q> you enquire.\b
   <q>That's none of your business,</q> he snaps, <q>except insofar as it
    involves my having to guard scum like you!</q>"
   isActive = gRevealed('guard-contract') 
;

++ AskTellAboutForTopic, SuggestedAskTopic, StopEventList @t_lawyer
  [
    '<q>I\'d like to see a laywer!</q> you request.\b
       The guardian gives a scornful snort. <q>You really <i>must</i> be
       a hardened reprobate if you want to see one of those parasites.
       Fortunately, they\'ve all been abolished.</q>',
       
      
     '<q>Do you mean to say there are no more lawyers?</q> you ask.\b
      <q>That\'s right.</q> he smiles thinly, <q>A totally unproductive
      profession that stood in the way of natural justice. We\'re much
      better off without them.</q>',
    
    '<q>I demand legal representation; it\'s my right!</q> you declare.\b
     <q>You don\'t have any rights -- you\'re a criminal.</q> he replies.' 
    
  ]
  name = 'a lawyer'
;

++ AskTellTopic @t_cell
  "<q>I don't think much of my cell.</q> you complain, <q>It's cramped, uncomfortable 
   and depressing.</q>\b
   <q>Excellent!</q> he declares, <q>I'd hate to think you actually liked it!<q>. "
;

++ AskTopic @smallPanel
  "<q>What's that panel for?</q> you wonder.\b
   <q>None of your business.</q> he grunts. "
;

++ AskTellTopic, StopEventList @desk
  [ 
    '<q>That\'s rather an ancient desk I found in my cell.</q> you remark.\b
     <q>What do you expect, that we buy you a brand new one?</q> he asks
     incredulously. ',
     
    '<q>If you\'re so keen on punishing me, I\'m surprised you left me a desk
     at all.</q> you remark.\b
     <q>So am I.</q> the guardian agrees, <q>If it were up to me I\'d give criminals
     like you nothing but a bullet in the gut.</q>',
     
    '<q>So, what am I meant to do with the desk?</q> you ask.\b
     <q>Frankly, I don\'t care if you eat it,</q> he replies, <q>I just hope
     it chokes you -- then I can go off an do something more interesting.</q>'  
  ]
;

++ AskTellTopic, SuggestedAskTopic, CyclicEventList @gPlayerChar
 [
   '<q>Who am I?</q> you ask, <q>I don\'t remember anything!</q>\b
    <q>You\'re a criminal -- that\'s all either of us need to know.</q> he replies.',
    
   '<q>But I\'ve no idea who I am or what I\'m meant to have done!</q> you protest.\b
    <q>What makes you think you\'re entitled to your memories?</q> he demands,
    <q>Let alone to answers! You\'re a criminal, and criminals have no rights --
     you\'re not entitled to <i>anything</i>!</q>',
     
   '<q>If you don\'t know anything about me, why are you so hostile?</q> you want to know.\b
    <q>But I do know something about you,</q> the guardian points out, <q>I know you\'re
    a criminal, which makes you an enemy of society, and I\'m paid to be hostile to 
    enemies of society -- that\'s my job.</q>'  
    
 ]   
 name = 'yourself'
;

++ TellTopic, SuggestedTellTopic [t_square, domedCeiling]
  "<q>I think I may have done it!</q> you announce.\b
   <q>Done what?</q> he asked.\b
   <q>Drawn a square circle!</q> you declare, <q>I drew a square on that
    glass-topped table, and projected it onto the domed ceiling with the
    light cube under the table. When you look at the ceiling, the square
    looks almost round!</q>\b
    <q><i>Almost</i> round isn't good enough,</q> he grunts, <q>Besides,
     I don't think <i>projecting</i> a square circle counts; you're meant to
     be drawing one.</q>"
  name = 'the domed ceiling'
  isActive = gRevealed('projected-square')
;

++ AskTellTopic, SuggestedAskTopic, StopEventList @t_squareCircle
   [
    '<q>How on earth am I meant to draw a square circle?</q> you ask.\b
     <q>That\'s your problem.</q> the guardian shrugs, <q>But you won\'t get out
      till you do, that\'s for sure!</q>',
    '<q>But everyone knows that square circles are impossible!</q> you protest,
     <q>So what kind of a task is that -- to draw a square circle?</q>\b
     <q>A difficult one, apparently.</q> the guardian replies, <q>So you\'d best stop
      wasting time and get on with it!</q>',  
     '<q>Do <i>you</i> know how to draw a square circle?</q> you ask him.\b
      <q>Nope</q> he admits cheerfully, <q>But I do wish you\'d hurry up and find out,
       then we can both get out of here!</q>' 
   ]
   name = 'the square circle'
;

+++ AltTopic, SuggestedTellTopic
   "<q>I think I've drawn a square circle!</q> you announce proudly.\b
    <q>Show me!</q> he demands sceptically. "
   name = 'the square circle'
   isActive = (globe.squareCircleDrawnOn != nil)
;

++ AskTellTopic, SuggestedAskTopic, StopEventList @guardian
  [
   '<q>So, why do you do this job?</q>\b
   <q>Someone has to,</q> the guardian shrugs. <q>So long as there are criminal
    elements like you there\'ll be a need for people like me.</q>',
    
   '<q>Is this really the best job you can get?</q> you ask.\b
    <q>Of course.</q> he replies, <q>I am serving the state in a capacity ideally
    suited to my temperament and abilities. What could possibly be more rational
    than that?</q>',
    
    '<q>Do you have a family?</q> you wonder.\b
     <q>Naturally -- it is the rational duty of law-abiding citizens to reproduce
      and nurture the next generation in a wholesome environment.</q> he tells you. ',
    
   '<q>Tell me about your family.</q> you suggest.\b
    <q>I make it a rule <i>never</i> to discuss my private life with prisoners.</q>
     he smiles thinly.',
     
    '<q>Tell me more about yourself.</q> you request.\b
    <q>Certainly not!</q> he replies, <q>I can talk about myself to family,
     friends and colleagues. Why on earth should I discuss my life with criminals?</q>'     
     
  ]
  name = 'himself'
;

++ AskTellTopic @newspaper
  "<q>That looks an -- er -- interesting newspaper you're reading.</q> you remark.\b
   <q>Yes, and if you've nothing better to talk about I'd rather be left alone
    to enjoy it.</q> the guardian growls."
;

++ AskForTopic @t_help
   "<q>I wonder if you could help me...</q> you begin, tentatively.\b
    <q>Certainly not!</q> he snaps, <q>I'm not here to help you -- you're a
     criminal!</q> ";
;

++ GiveShowTopic @note
   "<q>Do you know what's in this note?</q> you ask.\b
    {The guardian/he} gives it a quick glance, <q>Yup!</q> he affirms. "
;

++ GiveShowTopic [blueBook, greenBook]
   "<q>That's been left for you to study, not me,</q> the guard waves it away
    dismissively, <q>Who knows? You might even learn something!</q>"
;

++ GiveShowTopic +110 [rubberSheet, note, foodNote, globe]
   "<q>Look, I've drawn a square on this <<gDobj.name>>!</q> you declare.\b
    The guardian looks at your scrawled figure then shakes his head
    derisively, <q>So what?</q> he retorts, <q>It's just a square -- not
    a square circle!</q> "
   isActive = (gDobj.doodles <> nil && gDobj.doodles.indexOf(t_square) <> nil)
;

+++ AltTopic
   "<q>Here, I've drawn a circle!</q> you announce proudly, showing him 
    {the dobj/him}.\b
    <q>Not much of a circle, more of a wobbly elipse,</q> he complains,
    <q>anyway, it's certainly not a <i>square</i> circle!</q>"
   isActive = (gDobj.doodles <> nil && gDobj.doodles.indexOf(t_circle) <> nil)
;

+++ AltTopic
    "<q>Look at this!</q> you declare, handing him {the dobj/him}, <q>I've
     drawn a square circle!</q>\b
     {The guardian/he} takes it, and snorts after a single glance, <q>You've
     done no such thing!</q> he retorts, <q>You've simply drawn a square
     <i>and</i> a circle on the same surface, and as any idiot can see, that's
     not the same thing at all.</q> <<gDobj == rubberSheet ? 'He proceeds to
     distort the sheet this way and that, laughing scornfully all the while,
     <q>Look, it <i>still</i> doesn\'t make a square circle however much I bend
     and twist it!</q> ' : ''>>So saying, he tosses {the dobj/him} back to you with
     a gesture of contempt. "
     
    isActive = (gDobj.doodles <> nil && gDobj.doodles.indexOf(t_circle) <> nil
     && gDobj.doodles.indexOf(t_square) <> nil) 
;


++ AskTellGiveShowTopic, SuggestedShowTopic + 200 [globe, meridian, equator] 
    "<q>Well?</q> asks the guardian.\b
     <q>I've drawn a circle round <<globe.squareCircleDrawnOn.theName>> of this globe,</q>
      you tell him.\b
      <q>So?</q> he asks.<.convnode square><.p>" 
     isActive = (globe.squareCircleDrawnOn != nil) 
     includeInList = [&tellTopics, &giveTopics, &showTopics]

     name = 'the globe'
;

++ NoTopic
   "<q>No what?</q> he demands. "   
;

++ YesTopic
   "<q>Yes what?</q> he asks. "
;

++ AskTopic, StopEventList @pistol
   [
     '<q>That\'s an impressive-looking gun you\'ve got,</q> you observe nervously.<.p>
      <q>It sure is,</q> he agrees equably, <q>and it\'s effective too!</q>',
      
     '<q>Have you ever used that gun?</q> you ask.<.p>
      <q>Frequently,</q> he replies, <q>And I never hesitate to!</q>' 
   ]
;


++ DefaultAskForTopic
   "<q>You can't have it,</q> he grunts. "
;

++ DefaultAskTellTopic, ShuffledEventList
  [
    'The guardian suddenly spots something in his paper that catches his eye and ignores
     your remark. ',
    '<q>I don\'t feel like talking about that right now.</q> the guardian replies grumpily,
     <q>There\'s nothing in my contract that says I have to talk to you, right?</q>
     <.reveal guard-contract>',
    'The guardian rolls his eyes in irritation, <q>The trouble with you prisoners these days
     is you will <i>chatter</i> so much; why people feel the need to inflict their
     senseless conversation on others is beyond me.</q><.p>',  
    '<q>Look, if I wanted to discuss that, I\'d talk to my friends about it, or maybe my
     family.</q> the guardian tells you, <q>I certainly don\'t see any need to discuss it
     with <i>you</i>.</q><.p>',
    '<q><q>\^' + topicText() +  '</q></q> he repeats, shaking his head, <q><q>' 
      + topicText() + '</q>. Why are people always so anxious to talk about <q>'
      + topicText() + '</q>?</q><.p>'
  ]
  deferToEntry(other) { return !other.ofKind(DefaultTopic) 
    || other.ofKind(DefaultCommandTopic); }

;

++ DefaultGiveShowTopic
   "He glances at {the dobj/him} and <<gDobj.ofKind(NonPortable) ? 'then turns
    away from' : 'waves'>> {it dobj/him} <<gDobj.ofKind(NonPortable) ? '' : 'away'>> 
    with far more irritation than interest. "
    deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;


+ guardianWatching : ActorState
   specialDesc = "The guardian is standing in the middle of the road. <.reveal guard-watch>"
   stateDesc = "He's standing in the middle of the road. "
   distantSpecialDesc = "A man in the uniform of the Punishment Service is standing
    in the middle of the road some way off to the east; he's looking this way and that
    as if keeping a lookout for someone.<<gSetSeen(getActor)>><.reveal guard-watch>"  
   remoteSpecialDesc(pov) { distantSpecialDesc; }  
   afterAction()
   {
     if(gPlayerChar.isIn(getActor.location) && gActionIs(TravelVia))
     {
      "<q>You!</q> cries the guardian, <q>Thought you could escape did you!</q>
      He pulls out his pistol and points it at you, <q>Right -- that way!</q> he
      nods towards the prison gates.<.p>";      
      whiteCoat.moveIntoForTravel(nil);
      getActor.setCurState(guardianLeading);
     }
   }
   activateState(actor, oldState) 
   { 
     if(!pistol.isIn(holster))
       pistol.moveIntoForTravel(holster);
     inherited(actor, oldState);  
   }

;

+ guardianLeading : AccompanyingState, HermitActorState
  specialDesc = "The guardian is pointing his pistol at you, waiting for
   you to move. "
  stateDesc = "He's pointing his pistol at you, waiting for you to move. " 
  activateState(actor, oldState) 
   { 
     if(!pistol.isHeldBy(guardian))
       pistol.moveIntoForTravel(guardian);
     inherited(actor, oldState);  
   }
  beforeTravel(traveler, conn)
  {
    if(traveler == gPlayerChar)
    {
      if((traveler.location == prisonRoad && conn != prisonGate)
        || (traveler.location == avenue && conn != avenue.south))
      {  
        "<q>Not that way!</q> the guardian growls threateningly.\b ";
         exit;  
      }
    }    
    inherited(traveler, conn);
  }
  arrivingTurn()
  {
    if(getActor.location == driveway)
      getActor.setCurState(guardianPistol);
    else
     "<.p><q>Keep going!</q> the guardian prods you. ";
  }
  getAccompanyingTravelState (traveler, connector)  
  {
    return new guardianProdding(location, traveler, self);
  }
  accompanyTravel(traveler, conn) { return traveler == gPlayerChar; }
  afterAction()
  {
    if(!gActionIs(TravelVia) && gAction.actionTime > 0)
      "<.p><q>Keep going, we haven't got all day!</q> the guardian insists. ";
  }
  noResponse = "The guardian prods you in the back with his pistol. "
;

class guardianProdding : AccompanyingInTravelState
  sayDeparting(conn)
  {
    "The guardian follows you closely, with his pistol prodding your back. ";
  }
  specialDesc = "The guardian keeps his pistol at your back. ";
;


+ guardianPistol : HermitActorState
  specialDesc = "The guardian is covering you with his machine-pistol. "
  stateDesc = "He has his pistol pointed straight at you. "
  noResponse = "In reply, he merely waves his pistol at you. "
  activateState(actor, oldState) 
   { 
     if(!pistol.isHeldBy(guardian))
       pistol.moveIntoForTravel(guardian);
     inherited(actor, oldState);  
   }
  afterAction()
  {
    if(getActor.canSee(gPlayerChar) && !getActor.canSee(whiteCoat))
    {
      "<q>Here he is!</q> he calls.<.p>";
      whiteCoat.moveIntoForTravel(guardian.getOutermostRoom);
      "In response, the white-coated man comes running into 
        <<guardian.getOutermostRoom.destName>>.<.p>";
      
    }
    inherited;
  }
;

+ powerCutAgenda : ConvAgendaItem
  invokeItem
  {
     "<q>It seems there's been a power cut.</q> the guardian remarks,
      <q>But I'm sure they'll fix it soon.";
      if(getActor.canSee(lightCube))
        " In the meantime, you'll just have to make do with that light cube.";
      "</q>\b";
      said = true;
  }
  said = nil
  isDone = (said || !getActor.isIn(guardChair))
  isReady = (inherited && getActor.canTalkTo(gPlayerChar))
;

+ ConvNode 'not-going-somewhere';

++ YesTopic
  "<q>Yes, I thought I'd go for a stroll,</q> you reply.<.p>
   <q>Then think again!</q> he tells you. "
;

++ NoTopic
  "<q>Me? Go somewhere? Of course not!</q> you reply innocently.<.p>
   <q>I should think not!</q> says the guardian. "
;




guardianAchievement : Achievement +2 "getting the guardian out of the way" 
;