/*
 * 		SAMPLE.T				version 1.0
 *		by Kevin Forchione		( Lysseus@msn.com )
 *		Copyright (c) 1999. 	All Rights Reserved.
 *
 *  	This file requires HTML TADS 2.3.0 or later.
 *
 *  	You may modify and use this file in any way you want, provided that
 *		if you redistribute modified copies of this file in source form, the
 *   	copies must include the original copyright notice (including this
 *   	paragraph), and must be clearly marked as modified from the original
 *   	version.
 *
 *   	This file demonstrates the uses of consultItem class and the CONSULT and LOOK UP
 *		verbs. A consultItem object is a non-Actor object in which the player can 
 *		CONSULT or LOOK UP topics of interest, such as in a book or encyclopedia.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		99-03-13:	Creation.
 */

// Since this is an HTML TADS game, let's use the HTML status line
#define USE_HTML_STATUS

#include    <adv.t>         // Adventure Library
#include	<std.t>			// Standard definitions required by the system & library
#include	<consult.t>

startroom: room
	sdesc = "Reading Room"
	ldesc = "The room is stuffed with comfortable chairs and appears ideal for
		reading. An exit leads south to the library."
	south = library
;

table: surface, fixeditem
	location = startroom
	sdesc = "table"
	noun = 'table'
	ldesc = "It's an oaken table, just like your grandmother used to own."
;

bowl: container
	location = table
	sdesc = "wooden bowl"
	noun = 'bowl'
	adjective = 'wooden'
;

apple: item
	location = bowl
	sdesc = "apple"
	noun = 'apple'
;

peach: item
	location = bowl
	sdesc = "peach"
	noun = 'peach'
;

/*
 *	bible: consultItem
 *
 *	This object demonstrates one use of consultWord(); using a one- or 
 *	two-word list and formatting a display string. More elaborate editing
 *	would be required to make this fool-proof, but it mimics the Tyndale
 *	Bible found in Museum.t.
 *
 *	The consultObj() method is overriden only to send a general message to the
 *	player if they try to reference anything but 'matthew', 'mark', 'luke' or
 *	'john'.
 */
bible: consultItem
	location = table
	sdesc = "Tyndale Bible"
	ldesc = "A splendid foot-high Bible, which must have survived 
    	the burnings of 1520. (Oddly enough it's the same one that you 
    	saw in the Museum of Inform just last week.) Try CONSULT BIBLE 
    	ABOUT MATTHEW 4 or LOOK UP MARK IN BIBLE."
	noun = 'bible' 'book'
	adjective = 'black' 'tyndale'
	consultObj( actor, obj ) =
	{
		"There are only the four Gospels. ";
	}
	consultWord( actor, wlst ) =
	{
		local x, w;
		w := wlst[ 1 ];
		
		switch( w )
		{
			case 'matthew':
				x := 'Gospel of St. Matthew';
				break;
			case 'mark':
				x := 'Gospel of St. Mark';
				break;
			case 'luke':
				x := 'Gospel of St. Luke';
				break;
			case 'john':
				x := 'Gospel of St. John';
				break;
			default:
				self.consultObj( nil, nil );
		}
		if ( x )
		{
			if ( length( wlst ) = 1 )
			{
				"You read the "; say( x ); " right through. ";
			}
			else
			{
				local n;
				n := cvtnum( wlst[ 2 ] );
				if ( n and n <> true )
				{
					"Chapter "; say( wlst[ 2 ] ); " in the "; say( x ); " is too
					sacred for you to understand now. ";
				}
				else
				{
					"I was expecting a chapter number in "; say( x ); ". ";
				}
			}
		}
	}
;

library: room
	sdesc = "Library"
	ldesc = "The library is filled with shelves lined with books on all manner
		of subjects. One book in particular draws your attention. The exit is
		to the north."
	north = startroom
;

/*
 *	encyclopaedia: consultItem
 *
 *	Note that this object overrides the consultObj() method and is followed by
 *	topic objects that do not appear in the game, but are created solely for 
 *	reference by the encyclopaedia. It uses the default consultWord() method
 *	of the consultItem class for handling any unknown words.
 */
encyclopaedia: consultItem
	location = library
	sdesc = "Encyclopaedia Of English Literature"
	adesc = "an <<self.sdesc>>"
	noun = 'encyclopaedia' 'encyclopedia' 'book'
	adjective = 'english' 'literature'
	ldesc = "A massive tome (you may have seen a copy floating around in 
		Inform's library extension Info.h ). Try CONSULT BOOK ON VIRGINA
		WOOLF or LOOK UP NOVEL ORLANDO IN BOOK."
	consultObj( actor, iobj ) =
	{
		switch( iobj )
		{
			case virginia_woolf:
            	"<q>Woolf, Virginia (1182-1941), English novelist and
            	essayist.  The daughter of Sir Leslie Stephen, she
	            married the critic Leonard Sidney Woolf (1880-1969) and
	            they established the Hogarth Press (1917).  Novels using
	            stream of consciousness, such as Mrs. Dalloway (1925), To
	            the Lighthouse (1927) and The Waves (1931), concern her
	            characters' thoughs and feelings about common
	            experiences.  Some of her brilliant criticism was
	            published in The Common Reader (1925).  Subject to fits
	            of mental instability, she finally drowned herself.</q> ";
	            break;
	         case orlando:
	            "<q>A novel written in 1928 by Virgina Woolf outlining the
	            unual life of Orlando, an individual who lives for 400
	            years and is at one time male and another time female.
	            See also: Woolf, Virgina.</q>";
	            break;
	   		default: 
	   			"There is no entry in <<self.thedesc>> for <q><<iobj.sdesc>></q>. ";
         }
	}
;

/* 
 *	The following are simply abstract topics for the encyclopaedia and do not
 *	appear in the game.
 */
virginia_woolf: item
	noun = 'woolf'
	adjective = 'virgina'
;

orlando: item
	noun = 'orlando'
	adjective = 'novel' 'book'
;

/*
 *	Let's have a little HTML in this game!
 */
replace commonInit: function
{
	"\H+";
	"<P>You find yourself standing in the Consultation Rooms of HTML TADS.
	Having nothing more pressing to do, you find yourself browsing through
	some of the literature.<P>";
}
;
